/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.util;

import edu.calstatela.scivi.util.ResourceManager;
import edu.calstatela.scivi.util.URLLauncherException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class URLLauncher {
    public static void localOpenURL(String url) throws URLLauncherException {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new URLLauncherException(ResourceManager.getString("error.browser.notfound"));
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            throw new URLLauncherException(ResourceManager.getString("error.browser.open") + ":\n" + e.getLocalizedMessage());
        }
    }

    public static void jnlpOpenURL(String url) throws URLLauncherException {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
            bs.showDocument(new URL(url));
        }
        catch (UnavailableServiceException ue) {
            throw new URLLauncherException(ResourceManager.getString("error.browser.open") + ":\n" + ue.getLocalizedMessage());
        }
        catch (MalformedURLException mue) {
            throw new URLLauncherException(ResourceManager.getString("error.browser.open") + ":\n" + mue.getLocalizedMessage());
        }
    }

    public static void openURL(String url) throws URLLauncherException {
        URLLauncherException mue = null;
        try {
            URLLauncher.localOpenURL(url);
            return;
        }
        catch (URLLauncherException ex) {
            mue = ex;
            try {
                URLLauncher.jnlpOpenURL(url);
                return;
            }
            catch (URLLauncherException ex2) {
                mue = ex2;
                throw new URLLauncherException(ResourceManager.getString("error.browser.open") + ":\n" + mue.getLocalizedMessage());
            }
        }
    }
}

