/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.util;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ResourceManager {
    private static ResourceBundle resources = null;
    private static ResourceManager instance = null;

    protected ResourceManager() {
    }

    private static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public static String getString(String key) {
        return resources.getString(key);
    }

    public static ImageIcon getImageIcon(String key) {
        URL imageURL = ResourceManager.getInstance().getClass().getClassLoader().getResource(ResourceManager.getString(key));
        return new ImageIcon(imageURL);
    }

    public static BufferedImage getImage(String key) throws IOException {
        URL imageURL = ResourceManager.getInstance().getClass().getClassLoader().getResource(ResourceManager.getString(key));
        return ImageIO.read(imageURL);
    }

    public static URL getURL(String key) {
        return ResourceManager.getInstance().getClass().getClassLoader().getResource(ResourceManager.getString(key));
    }

    public static String loadTxtFile(String key) {
        String path = ResourceManager.getString(key);
        InputStream is = ResourceManager.getInstance().getClass().getClassLoader().getResourceAsStream(path);
        StringBuffer text = new StringBuffer();
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                text.append(line).append("\n");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return text.toString();
    }

    public static AudioClip getAudioClip(String key) throws MalformedURLException {
        URL url = ResourceManager.getInstance().getClass().getClassLoader().getResource(ResourceManager.getString(key));
        return Applet.newAudioClip(url);
    }

    static {
        resources = ResourceBundle.getBundle("res.MessagesBundle", Locale.getDefault());
    }
}

