/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageUtil {
    protected ImageUtil() {
    }

    public static BufferedImage resizeImage(BufferedImage img, Dimension newSize) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        int transparency = img.getColorModel().getTransparency();
        long start1 = System.nanoTime();
        BufferedImage resize = gc.createCompatibleImage((int)newSize.getWidth(), (int)newSize.getHeight(), transparency);
        Graphics2D g2 = resize.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        double scalex = (double)resize.getWidth() / (double)img.getWidth();
        double scaley = (double)resize.getHeight() / (double)img.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scalex, scaley);
        g2.drawRenderedImage(img, xform);
        g2.dispose();
        long end1 = System.nanoTime();
        System.out.println("image resize time: " + (double)(end1 - start1) / 1.0E9 + " s");
        return resize;
    }
}

