/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.util.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ZoomEffectJPanel
extends JPanel {
    BufferedImage origImg = null;
    private boolean done = false;
    private int w;
    private int h;
    BufferedImage currentImg = null;
    private int currentWidth;
    private int currentHeight;
    private static final int loopCount = 25;
    private static BufferedImage[] pre_renderedImages = new BufferedImage[25];
    private static boolean pre_render = false;
    private ZoomInAnimationCanvas canvas = null;

    public ZoomEffectJPanel(BufferedImage img, int width, int height) {
        this.w = width;
        this.h = height;
        this.origImg = img;
        this.canvas = new ZoomInAnimationCanvas(img);
        this.setLayout(new BorderLayout());
        this.add(this.canvas);
        this.setSize(width, height);
        this.setVisible(true);
    }

    public static void buildImageList(BufferedImage img, int width, int height) {
        int w = width;
        int h = height;
        int wAdj = (img.getWidth() - w) / 25;
        int hAdj = (img.getHeight() - h) / 25;
        for (int i = 0; i < 25; ++i) {
            System.out.println("CURRENT SIZE " + w + ", " + h);
            Dimension newSize = new Dimension(w += wAdj, h += hAdj);
            ZoomEffectJPanel.pre_renderedImages[i] = ImageUtil.resizeImage(img, newSize);
        }
        pre_render = true;
    }

    public void startAnimation() {
        this.done = false;
        new Thread(this.canvas).start();
    }

    public boolean isDone() {
        return this.done;
    }

    class ZoomInAnimationCanvas
    extends JComponent
    implements Runnable {
        BufferedImage origImg = null;

        protected ZoomInAnimationCanvas(BufferedImage img) {
            this.origImg = img;
        }

        public void run() {
            int width = ZoomEffectJPanel.this.w;
            int height = ZoomEffectJPanel.this.h;
            int loopCount = 10;
            int wAdj = (this.origImg.getWidth() - ZoomEffectJPanel.this.w) / loopCount;
            int hAdj = (this.origImg.getHeight() - ZoomEffectJPanel.this.h) / loopCount;
            long start = System.nanoTime();
            for (int i = 0; i < loopCount; ++i) {
                System.out.println("CURRENT SIZE " + (width += wAdj) + ", " + (height += hAdj));
                ZoomEffectJPanel.this.currentWidth = width;
                ZoomEffectJPanel.this.currentHeight = height;
                long startTime = System.currentTimeMillis();
                this.repaint();
                long endTime = System.currentTimeMillis();
                long waitTime = 250L - (endTime - startTime);
                try {
                    if (waitTime <= 0L) continue;
                    Thread.sleep(waitTime);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ZoomEffectJPanel.this.done = true;
            ZoomEffectJPanel.this.currentWidth = 800;
            ZoomEffectJPanel.this.currentWidth = 300;
            this.repaint();
            long end = System.nanoTime();
            System.out.println("zooming time: " + (double)(end - start) / 1.0E9 + " s");
        }

        public void paintComponent(Graphics g) {
            if (this.origImg != null) {
                super.paintComponents(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2.drawImage(this.origImg, 0, 0, ZoomEffectJPanel.this.currentWidth, ZoomEffectJPanel.this.currentHeight, null);
            }
        }
    }
}

