/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.control.MainController;
import edu.calstatela.scivi.model.Supernova;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class SupernovaJPanel
extends JPanel
implements Cloneable {
    private Supernova supernova;
    private int panelSize;
    private boolean drawBorder = false;
    private boolean alwaysDrawBorder = false;
    private MainController clickHandler;

    public SupernovaJPanel(Supernova supernova, int size, MainController ctrl) {
        this.supernova = supernova;
        this.panelSize = size;
        this.clickHandler = ctrl;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SupernovaJPanel.this.formMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                SupernovaJPanel.this.formMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                SupernovaJPanel.this.formMouseExited(evt);
            }
        });
        int x = supernova.getX() - size / 2;
        int y = supernova.getY() - size / 2;
        this.setBounds(x, y, size, size);
        this.setOpaque(false);
        this.setCursor(new Cursor(12));
        this.setVisible(true);
    }

    public void recomputeLocation() {
        int x = this.supernova.getX() - this.panelSize / 2;
        int y = this.supernova.getY() - this.panelSize / 2;
        this.setBounds(x, y, this.panelSize, this.panelSize);
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clickHandler.supernovaClicked(this.supernova.getID());
    }

    private void formMouseExited(MouseEvent evt) {
        this.drawBorder = false;
        this.repaint();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.drawBorder = true;
        this.repaint();
    }

    public void setAlwaysDrawBorder(boolean value) {
        this.alwaysDrawBorder = value;
    }

    public void paintComponent(Graphics g) {
        this.recomputeLocation();
        super.paintComponent(g);
        if (this.drawBorder || this.alwaysDrawBorder) {
            g.setColor(Color.RED);
            int start = 5;
            int end = this.panelSize - 5;
            g.drawOval(start, start, end - start, end - start);
            g.drawOval(start + 1, start + 1, end - start - 1, end - start - 1);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

