/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.control.MainController;
import edu.calstatela.scivi.model.Supernova;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class SupernovaImageJPanel
extends JPanel {
    private Supernova supernova;
    private int panelSize;
    private boolean drawBorder = false;
    private boolean alwaysDrawBorder = false;
    private MainController clickHandler;
    private BufferedImage novaImage;

    public SupernovaImageJPanel(Supernova supernova, int size, BufferedImage novaImage, MainController ctrl) {
        this.supernova = supernova;
        this.novaImage = this.modifyImage(novaImage);
        this.panelSize = size;
        this.clickHandler = ctrl;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SupernovaImageJPanel.this.formMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                SupernovaImageJPanel.this.formMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                SupernovaImageJPanel.this.formMouseExited(evt);
            }
        });
        int x = supernova.getX() - size / 2;
        int y = supernova.getY() - size / 2;
        this.setBounds(x, y, size, size);
        this.setOpaque(false);
        this.setCursor(new Cursor(12));
        this.setVisible(true);
    }

    private BufferedImage modifyImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage outImg = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int value = image.getRGB(x, y);
                int r = value & 0xFF;
                int g = value >>> 8 & 0xFF;
                int b = value >>> 16 & 0xFF;
                int a = (r + g + b) / 3;
                value = r + (g << 8) + (b << 16) + (a << 24);
                outImg.setRGB(x, y, value);
            }
        }
        return outImg;
    }

    public void recomputeLocation() {
        int x = this.supernova.getX() - this.panelSize / 2;
        int y = this.supernova.getY() - this.panelSize / 2;
        this.setBounds(x, y, this.panelSize, this.panelSize);
    }

    private void formMouseClicked(MouseEvent evt) {
        this.clickHandler.supernovaClicked(this.supernova.getID());
    }

    private void formMouseExited(MouseEvent evt) {
        this.clickHandler.supernovaMouseOver(this.supernova.getID(), false);
        this.drawBorder = false;
        this.repaint();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.clickHandler.supernovaMouseOver(this.supernova.getID(), true);
        this.drawBorder = true;
        this.repaint();
    }

    public void setAlwaysDrawBorder(boolean value) {
        this.alwaysDrawBorder = value;
    }

    public void paintComponent(Graphics g) {
        this.recomputeLocation();
        super.paintComponent(g);
        g.drawImage(this.novaImage, 5, 5, this.panelSize - 10, this.panelSize - 10, null);
    }
}

