/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.ui.HintJFrame;
import edu.calstatela.scivi.ui.PanJScrollPaneSplit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class ScrollPaneFinderChartLink
implements AdjustmentListener {
    private PanJScrollPaneSplit scrollPane;
    private HintJFrame finderChart;
    private RectangleJPanel rectPanel;

    public ScrollPaneFinderChartLink(final PanJScrollPaneSplit scrollPane, final HintJFrame finderChart) {
        this.scrollPane = scrollPane;
        this.finderChart = finderChart;
        this.rectPanel = new RectangleJPanel(0, 0, 0, 0);
        finderChart.getJLayeredPane1().add((Component)this.rectPanel, JLayeredPane.POPUP_LAYER);
        finderChart.getJLayeredPane1().addMouseMotionListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                this.onMouseEvent(e);
            }

            public void mouseDragged(MouseEvent e) {
                this.onMouseEvent(e);
            }

            private void onMouseEvent(MouseEvent e) {
                Rectangle rect = scrollPane.getViewport().getViewRect();
                scrollPane.getHorizontalScrollBar().setValue(e.getX() * scrollPane.getImageWidth() / finderChart.getImageWidth() - rect.width / 2);
                scrollPane.getVerticalScrollBar().setValue(e.getY() * scrollPane.getImageHeight() / finderChart.getImageHeight() - rect.height / 2);
            }
        });
        this.adjustmentValueChanged(null);
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Rectangle rect = this.scrollPane.getViewport().getViewRect();
        int fullWidth = this.scrollPane.getImageWidth();
        int fullHeight = this.scrollPane.getImageHeight();
        int finderWidth = this.finderChart.getImageWidth();
        int finderHeight = this.finderChart.getImageHeight();
        int x = (int)(rect.getX() / (double)fullWidth * (double)finderWidth);
        int y = (int)(rect.getY() / (double)fullHeight * (double)finderHeight);
        int width = (int)(rect.getWidth() / (double)fullWidth * (double)finderWidth);
        int height = (int)(rect.getHeight() / (double)fullHeight * (double)finderHeight);
        this.rectPanel.setRect(x, y, width, height);
        this.finderChart.getJLayeredPane1().repaint();
    }

    public void setRectVisible(boolean value) {
        this.rectPanel.setRectVisible(value);
    }

    private class RectangleJPanel
    extends JPanel {
        private int width;
        private int height;
        private boolean visible = true;

        protected RectangleJPanel(int x, int y, int width, int height) {
            this.setRect(x, y, width, height);
        }

        protected void setRect(int x, int y, int width, int height) {
            this.setBounds(x, y, width, height);
            this.width = width;
            this.height = height;
        }

        public void setRectVisible(boolean value) {
            this.visible = value;
        }

        public void paintComponent(Graphics g) {
            if (this.visible) {
                g.setColor(new Color(0, 0, 120));
                g.drawRect(0, 0, this.width - 1, this.height - 1);
            }
        }
    }
}

