/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.model.Supernova;
import edu.calstatela.scivi.ui.HintJFrame;
import edu.calstatela.scivi.util.ImageUtil;
import edu.calstatela.scivi.util.ResourceManager;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadarEffectJLayeredPane
extends JLayeredPane {
    private List<Supernova> supernovae = null;
    private double Xfactor = 0.0;
    private double Yfactor = 0.0;
    private RadarAnimationCanvas canvas = null;
    private AudioClip beep = null;
    private boolean done = false;
    private boolean lineVisible;
    private HintJFrame hintFrame;

    public RadarEffectJLayeredPane(BufferedImage img, HintJFrame hintFrame, int width, int height) {
        this.Xfactor = (double)img.getWidth() / (double)width;
        this.Yfactor = (double)img.getHeight() / (double)height;
        try {
            this.beep = ResourceManager.getAudioClip("global.path.audio.beep");
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        BufferedImage small = null;
        small = ImageUtil.resizeImage(img, new Dimension(width, height));
        JLabel bg = new JLabel(new ImageIcon(small));
        bg.setBounds(0, 0, width, height);
        this.add((Component)bg, JLayeredPane.DEFAULT_LAYER);
        this.canvas = new RadarAnimationCanvas();
        this.canvas.setBounds(0, 0, width, height);
        this.canvas.setOpaque(false);
        this.add((Component)this.canvas, JLayeredPane.DRAG_LAYER);
        this.hintFrame = hintFrame;
        this.lineVisible = false;
        this.setSize(width, height);
        this.setVisible(true);
    }

    public void setLineVisible(boolean value) {
        this.lineVisible = value;
    }

    public void addNovaeList(List<Supernova> novaeList) {
        this.supernovae = novaeList;
    }

    private Point hasSupernova(int x) {
        for (Supernova nova : this.supernovae) {
            if ((int)((double)nova.getX() / this.Xfactor) != x) continue;
            return new Point(x, (int)((double)nova.getY() / this.Yfactor));
        }
        return null;
    }

    private Supernova findSupernova(int x) {
        for (Supernova nova : this.supernovae) {
            if ((int)((double)nova.getX() / this.Xfactor) != x) continue;
            return nova;
        }
        return null;
    }

    public void startAnimation() {
        this.done = false;
        new Thread(this.canvas).start();
    }

    public boolean isDone() {
        return this.done;
    }

    class NovaAnimationCanvas
    extends JComponent
    implements Runnable {
        int radius = 0;
        int size = 0;

        protected NovaAnimationCanvas(int size) {
            this.size = size;
            this.setSize(size, size);
            this.setOpaque(false);
        }

        public void run() {
            if (RadarEffectJLayeredPane.this.beep != null) {
                RadarEffectJLayeredPane.this.beep.play();
            }
            this.radius = 0;
            while (this.radius < 20) {
                this.repaint();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.radius += 4;
            }
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.GREEN);
            int i = this.radius - 8;
            if (i < 0) {
                i = 0;
            }
            while (i <= 10) {
                g.drawOval(10 - i / 2, 10 - i / 2, i, i);
                i += 2;
            }
        }
    }

    class RadarAnimationCanvas
    extends JComponent
    implements Runnable {
        private int i;

        protected RadarAnimationCanvas() {
        }

        public void run() {
            Graphics g = RadarEffectJLayeredPane.this.canvas.getGraphics();
            this.i = 0;
            while (this.i < 800) {
                Supernova supernova;
                this.repaint();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                Point nova = RadarEffectJLayeredPane.this.hasSupernova(this.i);
                if (nova != null) {
                    NovaAnimationCanvas novaCanvas = new NovaAnimationCanvas(20);
                    novaCanvas.setBounds(nova.x - 10, nova.y - 10, 20, 20);
                    this.add(novaCanvas);
                    new Thread(novaCanvas).start();
                }
                if ((supernova = RadarEffectJLayeredPane.this.findSupernova(this.i)) != null) {
                    RadarEffectJLayeredPane.this.hintFrame.makeTargetPanelVisible(supernova.getX(), supernova.getY());
                }
                ++this.i;
            }
            this.removeAll();
            RadarEffectJLayeredPane.this.done = true;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.GREEN);
            if (RadarEffectJLayeredPane.this.lineVisible) {
                g.drawLine(this.i, 0, this.i, 300);
            }
        }
    }
}

