/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.ui.SupernovaImageJPanel;
import edu.calstatela.scivi.ui.SupernovaJPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartPanel;

public class PanJScrollPaneSplit
extends JScrollPane
implements MouseListener,
MouseMotionListener,
ItemListener {
    private int labelWidth;
    private int labelHeight;
    private int imageWidth;
    private int imageHeight;
    private int xStart;
    private int yStart;
    private ArrayList<SupernovaJPanel> panelList;
    private ArrayList<SupernovaImageJPanel> panelImageList;
    private AutoScroll autoScroller = null;
    private static int scrollerCount = 0;
    private double xAdj = 20.0;
    private double yAdj = 5.0;
    private boolean autoScroll = false;
    private JPopupMenu contextMenu = null;
    private JCheckBoxMenuItem doScrollMenuItem = null;
    private JLayeredPane jLayeredPaneImage = null;
    private ChartPanel chartPanel = null;
    private boolean ignoreMouse;

    public PanJScrollPaneSplit(int width, int height) {
        this.labelWidth = width;
        this.labelHeight = height;
        this.autoScroller = new AutoScroll(this.getHorizontalScrollBar(), this.getVerticalScrollBar());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(12));
        this.doScrollMenuItem = new JCheckBoxMenuItem("Automatic Scroll");
        this.doScrollMenuItem.addItemListener(this);
        this.contextMenu = new JPopupMenu();
        this.contextMenu.add(this.doScrollMenuItem);
        this.ignoreMouse = false;
        this.panelList = new ArrayList(15);
        this.panelImageList = new ArrayList(15);
    }

    public PanJScrollPaneSplit(BufferedImage univImg, Dimension imagePaneDimension) {
        this.labelWidth = univImg.getWidth();
        this.labelHeight = univImg.getHeight();
        this.imageWidth = this.labelWidth;
        this.imageHeight = this.labelHeight;
        ImageIcon mainImage = new ImageIcon(univImg);
        JPanel jPanelImage = new JPanel();
        JLabel jLabelImage = new JLabel();
        jPanelImage.setBounds(0, 0, mainImage.getIconWidth(), mainImage.getIconHeight());
        jLabelImage.setIcon(mainImage);
        jPanelImage.add(jLabelImage);
        this.jLayeredPaneImage = new JLayeredPane();
        this.jLayeredPaneImage.setPreferredSize(new Dimension(univImg.getWidth(), univImg.getHeight()));
        this.jLayeredPaneImage.add((Component)jPanelImage, JLayeredPane.DEFAULT_LAYER);
        this.setMaximumSize(imagePaneDimension);
        this.setMinimumSize(imagePaneDimension);
        this.setPreferredSize(imagePaneDimension);
        this.setViewportView(this.jLayeredPaneImage);
        this.autoScroller = new AutoScroll(this.getHorizontalScrollBar(), this.getVerticalScrollBar());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(12));
        this.doScrollMenuItem = new JCheckBoxMenuItem("Automatic Scroll");
        this.doScrollMenuItem.addItemListener(this);
        this.contextMenu = new JPopupMenu();
        this.contextMenu.add(this.doScrollMenuItem);
        this.ignoreMouse = false;
        this.panelList = new ArrayList(15);
        this.panelImageList = new ArrayList(15);
    }

    public void setIgnoreMouse(boolean value) {
        this.ignoreMouse = value;
    }

    public void setChartPanel(ChartPanel panel) {
        if (this.chartPanel != null) {
            this.jLayeredPaneImage.remove(this.chartPanel);
        }
        panel.setOpaque(false);
        this.jLayeredPaneImage.add(panel);
        this.jLayeredPaneImage.moveToFront(panel);
        this.chartPanel = panel;
    }

    public void updateChartPanel(boolean visible, boolean side) {
        if (this.chartPanel != null) {
            Rectangle viewRect = this.getViewport().getViewRect();
            Dimension size = viewRect.getSize();
            size.width = (int)((float)size.width * 0.33f);
            size.height = (int)((float)size.height * 0.75f);
            if (!side) {
                this.chartPanel.setBounds(new Rectangle(viewRect.getLocation(), size));
            } else {
                this.chartPanel.setBounds(new Rectangle(new Point(viewRect.x + viewRect.width - size.width, viewRect.y + viewRect.height - size.height), size));
            }
            this.chartPanel.setVisible(visible);
        }
    }

    public void addSupernovaJPanel(SupernovaJPanel novaJPanel) {
    }

    public void addSupernovaJPanel(SupernovaImageJPanel novaImageJPanel) {
        this.jLayeredPaneImage.add((Component)novaImageJPanel, JLayeredPane.DRAG_LAYER);
        this.panelImageList.add(novaImageJPanel);
    }

    public void recomputePanelsLocation() {
        int i;
        int size = this.panelList.size();
        for (i = 0; i < size; ++i) {
            this.panelList.get(i).recomputeLocation();
        }
        size = this.panelImageList.size();
        for (i = 0; i < size; ++i) {
            this.panelImageList.get(i).recomputeLocation();
        }
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setAutoScroll(boolean auto) {
        this.autoScroll = auto;
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.setAutoScroll(true);
            this.setCursor(new Cursor(13));
        } else {
            this.setAutoScroll(false);
            this.setCursor(new Cursor(12));
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3) {
            this.contextMenu.show(this, e.getX(), e.getY());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.xStart = e.getX();
        this.yStart = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        int xDiff = e.getX() - this.xStart;
        int yDiff = e.getY() - this.yStart;
        if (!this.ignoreMouse) {
            if (Math.abs(xDiff) > 0) {
                int x = this.getHorizontalScrollBar().getValue();
                this.getHorizontalScrollBar().setValue(x - xDiff);
            }
            if (Math.abs(yDiff) > 0) {
                int y = this.getVerticalScrollBar().getValue();
                this.getVerticalScrollBar().setValue(y - yDiff);
            }
        }
        Rectangle rect = this.getViewport().getViewRect();
        System.out.println("X: " + rect.getX() + "; Y: " + rect.getY() + "; width: " + rect.getWidth() + "; height: " + rect.getHeight());
    }

    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        this.stopAutoScroll();
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.autoScroll) {
            return;
        }
        this.stopAutoScroll();
        int xDiff = e.getX() - this.getWidth() / 2;
        int yDiff = e.getY() - this.getHeight() / 2;
        if (Math.abs(xDiff) > 0 || Math.abs(yDiff) > 0) {
            this.autoScroller.hScrollValue = (int)((double)xDiff / this.xAdj / (1.0 * (double)this.labelWidth) * (double)this.getWidth());
            this.autoScroller.vScrollValue = (int)((double)yDiff / this.yAdj / (1.0 * (double)this.labelHeight) * (double)this.getHeight());
            new Thread(this.autoScroller).start();
        }
    }

    public void mouseDragged(MouseEvent e) {
        int xDiff = e.getX() - this.xStart;
        int yDiff = e.getY() - this.yStart;
        this.xStart = e.getX();
        this.yStart = e.getY();
        if (!this.ignoreMouse) {
            if (Math.abs(xDiff) > 0) {
                int x = this.getHorizontalScrollBar().getValue();
                this.getHorizontalScrollBar().setValue(x - xDiff);
            }
            if (Math.abs(yDiff) > 0) {
                int y = this.getVerticalScrollBar().getValue();
                this.getVerticalScrollBar().setValue(y - yDiff);
            }
        }
        Rectangle rect = this.getViewport().getViewRect();
    }

    private void stopAutoScroll() {
        if (this.autoScroller != null) {
            this.autoScroller.stopScroll();
        }
    }

    public void reset() {
        this.getHorizontalScrollBar().setValue(0);
        this.getVerticalScrollBar().setValue(0);
    }

    private class AutoScroll
    implements Runnable {
        private boolean keepGoing;
        private JScrollBar hScrollBar = null;
        private JScrollBar vScrollBar = null;
        public int hScrollValue = 0;
        public int vScrollValue = 0;

        public AutoScroll(JScrollBar hBar, JScrollBar vBar) {
            this.hScrollBar = hBar;
            this.vScrollBar = vBar;
        }

        public void run() {
            this.keepGoing = true;
            scrollerCount++;
            while (this.keepGoing && scrollerCount == 1) {
                if (this.hScrollBar != null) {
                    int h = this.hScrollBar.getValue();
                    this.hScrollBar.setValue(h + this.hScrollValue);
                }
                if (this.vScrollBar != null) {
                    int v = this.vScrollBar.getValue();
                    this.vScrollBar.setValue(v + this.vScrollValue);
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            scrollerCount--;
        }

        public void stopScroll() {
            this.keepGoing = false;
        }
    }
}

