/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.ui.PanJScrollPaneSplit;
import edu.calstatela.scivi.ui.SupernovaImageJPanel;
import edu.calstatela.scivi.ui.SupernovaJPanel;
import edu.calstatela.scivi.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PanJScrollPane
extends JPanel {
    private int width;
    private int height;
    private PanJScrollPaneSplit leftPane;
    private PanJScrollPaneSplit rightPane;
    private PaneLink paneLink;

    public PanJScrollPane(int width, int height) {
        this.width = width;
        this.height = height;
        this.leftPane = new PanJScrollPaneSplit(width / 2, height);
        this.rightPane = new PanJScrollPaneSplit(width / 2, height);
        this.paneLink = new PaneLink(this.leftPane, this.rightPane);
        this.leftPane.getHorizontalScrollBar().addAdjustmentListener(this.paneLink);
        this.leftPane.getVerticalScrollBar().addAdjustmentListener(this.paneLink);
        this.rightPane.getHorizontalScrollBar().addAdjustmentListener(this.paneLink);
        this.rightPane.getVerticalScrollBar().addAdjustmentListener(this.paneLink);
        this.leftPane.getHorizontalScrollBar().setEnabled(false);
        this.leftPane.getVerticalScrollBar().setEnabled(false);
        this.leftPane.setIgnoreMouse(true);
        this.setLayout(new BoxLayout(this, 0));
        JPanel leftPanePanel = new JPanel(new BorderLayout());
        JPanel rightPanePanel = new JPanel(new BorderLayout());
        JTextField leftPaneText = new JTextField(ResourceManager.getString("ui.main.mainwindow.text.leftscrollpane"));
        leftPaneText.setHorizontalAlignment(0);
        leftPaneText.setEditable(false);
        leftPaneText.setBackground(new Color(242, 244, 243));
        leftPaneText.setFont(leftPaneText.getFont().deriveFont(1));
        leftPanePanel.add((Component)leftPaneText, "North");
        leftPanePanel.add((Component)this.leftPane, "Center");
        JTextField rightPaneText = new JTextField(ResourceManager.getString("ui.main.mainwindow.text.rightscrollpane"));
        rightPaneText.setHorizontalAlignment(0);
        rightPaneText.setEditable(false);
        rightPaneText.setBackground(new Color(242, 244, 243));
        rightPaneText.setFont(rightPaneText.getFont().deriveFont(1));
        rightPanePanel.add((Component)rightPaneText, "North");
        rightPanePanel.add((Component)this.rightPane, "Center");
        this.add(leftPanePanel);
        this.add(rightPanePanel);
    }

    public PanJScrollPane(BufferedImage univImg, Dimension imagePaneDimension) {
        this.width = univImg.getWidth();
        this.height = univImg.getHeight();
        Dimension leftDimension = new Dimension();
        Dimension rightDimension = new Dimension();
        leftDimension.setSize(imagePaneDimension.getWidth() / 2.0, imagePaneDimension.getHeight());
        rightDimension.setSize(imagePaneDimension.getWidth() / 2.0, imagePaneDimension.getHeight());
        this.leftPane = new PanJScrollPaneSplit(univImg, leftDimension);
        this.rightPane = new PanJScrollPaneSplit(univImg, rightDimension);
        this.paneLink = new PaneLink(this.leftPane, this.rightPane);
        this.leftPane.getHorizontalScrollBar().addAdjustmentListener(this.paneLink);
        this.leftPane.getVerticalScrollBar().addAdjustmentListener(this.paneLink);
        this.rightPane.getHorizontalScrollBar().addAdjustmentListener(this.paneLink);
        this.rightPane.getVerticalScrollBar().addAdjustmentListener(this.paneLink);
        this.leftPane.getHorizontalScrollBar().setEnabled(false);
        this.leftPane.getVerticalScrollBar().setEnabled(false);
        this.leftPane.setIgnoreMouse(true);
        this.setLayout(new BoxLayout(this, 0));
        JPanel leftPanePanel = new JPanel(new BorderLayout());
        JPanel rightPanePanel = new JPanel(new BorderLayout());
        JLabel leftPaneText = new JLabel();
        leftPaneText.setText(ResourceManager.getString("ui.main.mainwindow.text.leftscrollpane"));
        leftPaneText.setFont(new Font(ResourceManager.getString("ui.main.mainwindow.font.panetext"), 1, leftPaneText.getFont().getSize()));
        leftPaneText.setHorizontalAlignment(0);
        leftPaneText.setBackground(new Color(242, 244, 243));
        leftPaneText.setFont(leftPaneText.getFont().deriveFont(1));
        leftPanePanel.add((Component)leftPaneText, "North");
        leftPanePanel.add((Component)this.leftPane, "Center");
        JLabel rightPaneText = new JLabel();
        rightPaneText.setText(ResourceManager.getString("ui.main.mainwindow.text.rightscrollpane"));
        rightPaneText.setFont(new Font(ResourceManager.getString("ui.main.mainwindow.font.panetext"), 1, rightPaneText.getFont().getSize()));
        rightPaneText.setHorizontalAlignment(0);
        rightPaneText.setBackground(new Color(242, 244, 243));
        rightPaneText.setFont(rightPaneText.getFont().deriveFont(1));
        rightPanePanel.add((Component)rightPaneText, "North");
        rightPanePanel.add((Component)this.rightPane, "Center");
        this.add(leftPanePanel);
        this.add(rightPanePanel);
    }

    public PanJScrollPaneSplit getLeftPane() {
        return this.leftPane;
    }

    public PanJScrollPaneSplit getRightPane() {
        return this.rightPane;
    }

    public void addSupernovaJPanel(SupernovaJPanel novaJPanel, SupernovaImageJPanel novaImageJPanel) {
        novaImageJPanel.setAlwaysDrawBorder(false);
        this.leftPane.addSupernovaJPanel(novaJPanel);
        this.rightPane.addSupernovaJPanel(novaImageJPanel);
    }

    public void recomputePanelsLocation() {
        this.leftPane.recomputePanelsLocation();
        this.rightPane.recomputePanelsLocation();
    }

    public void reset() {
        this.leftPane.reset();
        this.rightPane.reset();
    }

    private class PaneLink
    implements AdjustmentListener {
        private PanJScrollPaneSplit leftPane;
        private PanJScrollPaneSplit rightPane;

        public PaneLink(PanJScrollPaneSplit leftPane, PanJScrollPaneSplit rightPane) {
            this.leftPane = leftPane;
            this.rightPane = rightPane;
        }

        public void adjustmentValueChanged(AdjustmentEvent evt) {
            int leftHorizontalValue = this.leftPane.getHorizontalScrollBar().getValue();
            int leftVerticalValue = this.leftPane.getVerticalScrollBar().getValue();
            int rightHorizontalValue = this.rightPane.getHorizontalScrollBar().getValue();
            int rightVerticalValue = this.rightPane.getVerticalScrollBar().getValue();
            if (evt.getSource() == this.leftPane.getHorizontalScrollBar() || evt.getSource() == this.leftPane.getVerticalScrollBar()) {
                if (rightHorizontalValue != leftHorizontalValue) {
                    this.rightPane.getHorizontalScrollBar().setValue(leftHorizontalValue);
                }
                if (rightVerticalValue != leftVerticalValue) {
                    this.rightPane.getVerticalScrollBar().setValue(leftVerticalValue);
                }
            } else if (evt.getSource() == this.rightPane.getHorizontalScrollBar() || evt.getSource() == this.rightPane.getVerticalScrollBar()) {
                if (leftHorizontalValue != rightHorizontalValue) {
                    this.leftPane.getHorizontalScrollBar().setValue(rightHorizontalValue);
                }
                if (leftVerticalValue != rightVerticalValue) {
                    this.leftPane.getVerticalScrollBar().setValue(rightVerticalValue);
                }
            }
        }
    }
}

