/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.control.MainController;
import edu.calstatela.scivi.model.OmegaValues;
import edu.calstatela.scivi.model.helper.SupernovaData;
import edu.calstatela.scivi.model.helper.SupernovaGeneration;
import edu.calstatela.scivi.ui.AboutJDialog;
import edu.calstatela.scivi.ui.HintJFrame;
import edu.calstatela.scivi.util.ResourceManager;
import edu.calstatela.scivi.util.URLLauncher;
import edu.calstatela.scivi.util.URLLauncherException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainJFrame
extends JFrame {
    private JButton jButtonHint;
    private JButton jButtonReset;
    private JButton jButtonSaveData;
    private JButton jButtonLevel1;
    private JButton jButtonLevel2;
    private JButton jButtonLevel3;
    private JButton jButtonLevel4;
    private JButton jButtonLevel5;
    private JButton jButtonStartOver;
    private JButton jButtonUpdate;
    private JLabel jLabelConstant;
    private JLabel jLabelCosString;
    private JLabel jLabelDarkMatter;
    private JLabel jLabelHubble;
    private JLabel jLabelIcon;
    private JLabel jLabelMatter;
    private JLabel jLabelRadiation;
    private JLabel jLabelRedshift;
    private JLabel jLabelTexture;
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuItemFileEnd;
    private JMenuItem jMenuItemFileQuit;
    private JMenuItem jMenuItemFileStart;
    private JMenuItem jMenuItemHelpAbout;
    private JMenuItem jMenuItemHelpContents;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelImageHolder;
    private JPanel jPanelInput;
    private JPanel jPanelInputs;
    private JSeparator jSeparatorFile;
    private JSlider jSliderConstant;
    private JSlider jSliderCosString;
    private JSlider jSliderDarkMatter;
    private JSlider jSliderMatter;
    private JSlider jSliderRadiation;
    private JSlider jSliderRedshift;
    private JSlider jSliderTexture;
    private JTabbedPane jTabbedPaneCharts;
    private JTextField jTextFieldConstant;
    private JTextField jTextFieldCosString;
    private JTextField jTextFieldDarkMatter;
    private JTextField jTextFieldMatter;
    private JTextField jTextFieldRadiation;
    private JTextField jTextFieldRedshift;
    private JTextField jTextFieldTexture;
    private JLabel hintPaneText;
    private JTextArea message;
    private JTextArea graphTextArea;
    private double z;
    private double redshift;
    private double constant;
    private double darkMatter;
    private double matter;
    private double radiation;
    private double texture;
    private double cosString;
    private static MainJFrame singleton = null;
    private MainController ctrl = null;
    private Dimension mainAppWinSize = new Dimension(800, 600);
    public static final int STARTGAME = 0;
    public static final int ENDGAME = 1;

    public static MainJFrame getInstance(HintJFrame hintFrame, JLayeredPane jLayeredPane1) {
        if (singleton == null) {
            singleton = new MainJFrame(hintFrame, jLayeredPane1);
        }
        return singleton;
    }

    protected MainJFrame(HintJFrame hintFrame, JLayeredPane jLayeredPane1) {
        this.initComponents(hintFrame, jLayeredPane1);
        this.resetOmega();
        this.showButtons(1);
        Dimension scrn = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((scrn.width - this.getWidth()) / 2, (scrn.height - this.getHeight()) / 2, this.getWidth(), this.getHeight());
    }

    private void initComponents(HintJFrame hintFrame, JLayeredPane jLayeredPane1) {
        this.jPanelImageHolder = new JPanel();
        this.jTabbedPaneCharts = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanelInput = new JPanel();
        this.jPanelInputs = new JPanel();
        this.jLabelHubble = new JLabel();
        this.jLabelRedshift = new JLabel();
        this.jSliderRedshift = new JSlider();
        this.jTextFieldRedshift = new JTextField();
        this.jLabelRadiation = new JLabel();
        this.jSliderRadiation = new JSlider();
        this.jTextFieldRadiation = new JTextField();
        this.jLabelMatter = new JLabel();
        this.jSliderMatter = new JSlider();
        this.jTextFieldMatter = new JTextField();
        this.jLabelDarkMatter = new JLabel();
        this.jSliderDarkMatter = new JSlider();
        this.jTextFieldDarkMatter = new JTextField();
        this.jLabelCosString = new JLabel();
        this.jSliderCosString = new JSlider();
        this.jTextFieldCosString = new JTextField();
        this.jLabelTexture = new JLabel();
        this.jSliderTexture = new JSlider();
        this.jTextFieldTexture = new JTextField();
        this.jLabelConstant = new JLabel();
        this.jSliderConstant = new JSlider();
        this.jTextFieldConstant = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonUpdate = new JButton();
        this.jButtonReset = new JButton();
        this.jButtonSaveData = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonLevel1 = new JButton();
        this.jButtonLevel2 = new JButton();
        this.jButtonLevel3 = new JButton();
        this.jButtonLevel4 = new JButton();
        this.jButtonLevel5 = new JButton();
        this.jButtonStartOver = new JButton();
        this.jButtonHint = new JButton();
        this.jLabelIcon = new JLabel();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemFileStart = new JMenuItem();
        this.jMenuItemFileEnd = new JMenuItem();
        this.jSeparatorFile = new JSeparator();
        this.jMenuItemFileQuit = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuItemHelpContents = new JMenuItem();
        this.jMenuItemHelpAbout = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
        this.setTitle(ResourceManager.getString("global.app.title"));
        this.setResizable(false);
        this.jPanelImageHolder.setLayout(new BorderLayout());
        this.jPanelImageHolder.setMaximumSize(this.getImagePanelDimension());
        this.jPanelImageHolder.setMinimumSize(this.getImagePanelDimension());
        this.jPanelImageHolder.setPreferredSize(this.getImagePanelDimension());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        this.getContentPane().add((Component)this.jPanelImageHolder, gridBagConstraints);
        this.jTabbedPaneCharts.setPreferredSize(this.getTabPanelDimension());
        this.jTabbedPaneCharts.addTab("", this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 5);
        hintFrame.getContentPane().add(this.jTabbedPaneCharts);
        JPanel layerPanel = new JPanel(new BorderLayout(1, 1));
        Dimension dim = jLayeredPane1.getSize();
        dim.setSize(dim.getWidth() + 2.0, dim.getHeight() + 30.0);
        layerPanel.setSize((int)dim.getWidth(), (int)dim.getHeight());
        layerPanel.setPreferredSize(dim);
        this.hintPaneText = new JLabel("");
        this.hintPaneText.setFont(new Font(ResourceManager.getString("ui.main.mainwindow.font.panetext"), 1, this.hintPaneText.getFont().getSize()));
        this.hintPaneText.setBackground(new Color(242, 244, 243));
        layerPanel.add((Component)this.hintPaneText, "North");
        layerPanel.add((Component)jLayeredPane1, "Center");
        this.getContentPane().add((Component)layerPanel, gridBagConstraints);
        this.jPanelInput.setLayout(new BorderLayout(5, 5));
        this.jPanelInput.setPreferredSize(this.getInputPanelDimension());
        this.jPanelInputs.setLayout(new GridBagLayout());
        JPanel jPanelSepInputs = new JPanel();
        jPanelSepInputs.setLayout(new GridBagLayout());
        this.jLabelHubble.setFont(new Font("Impact", 1, 13));
        this.jLabelHubble.setForeground(new Color(255, 0, 0));
        this.jLabelHubble.setIcon(ResourceManager.getImageIcon("global.path.image.inputtitle"));
        this.jLabelHubble.setPreferredSize(new Dimension(250, 70));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanelSepInputs.add((Component)this.jLabelHubble, gridBagConstraints);
        this.jLabelRedshift.setFont(new Font("Tahoma", 0, 10));
        this.jLabelRedshift.setHorizontalAlignment(2);
        this.jLabelRedshift.setText(ResourceManager.getString("ui.main.label.omega.redshift"));
        this.jLabelRedshift.setHorizontalTextPosition(2);
        this.jLabelRedshift.setMaximumSize(new Dimension(100, 20));
        this.jLabelRedshift.setMinimumSize(new Dimension(100, 20));
        this.jLabelRedshift.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelRedshift, gridBagConstraints);
        this.jSliderRedshift.setMajorTickSpacing(4);
        this.jSliderRedshift.setMaximum(28);
        this.jSliderRedshift.setValue(0);
        this.jSliderRedshift.setMaximumSize(new Dimension(100, 25));
        this.jSliderRedshift.setMinimumSize(new Dimension(100, 25));
        this.jSliderRedshift.setPreferredSize(new Dimension(100, 25));
        this.jSliderRedshift.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        jPanelSepInputs.add((Component)this.jSliderRedshift, new GridBagConstraints());
        this.jTextFieldRedshift.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldRedshift.setText("0");
        this.jTextFieldRedshift.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldRedshift.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldRedshift.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldRedshift.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldRedshift.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldRedshift, gridBagConstraints);
        this.jLabelRadiation.setFont(new Font("Tahoma", 0, 10));
        this.jLabelRadiation.setHorizontalAlignment(2);
        this.jLabelRadiation.setText(ResourceManager.getString("ui.main.label.omega.radiation"));
        this.jLabelRadiation.setHorizontalTextPosition(2);
        this.jLabelRadiation.setMaximumSize(new Dimension(130, 20));
        this.jLabelRadiation.setMinimumSize(new Dimension(100, 20));
        this.jLabelRadiation.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelRadiation, gridBagConstraints);
        this.jSliderRadiation.setMajorTickSpacing(25);
        this.jSliderRadiation.setMaximum(200);
        this.jSliderRadiation.setValue(0);
        this.jSliderRadiation.setMaximumSize(new Dimension(100, 25));
        this.jSliderRadiation.setMinimumSize(new Dimension(100, 25));
        this.jSliderRadiation.setPreferredSize(new Dimension(100, 25));
        this.jSliderRadiation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jSliderRadiation, gridBagConstraints);
        this.jTextFieldRadiation.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldRadiation.setText("0");
        this.jTextFieldRadiation.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldRadiation.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldRadiation.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldRadiation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldRadiation.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldRadiation, gridBagConstraints);
        this.jLabelMatter.setFont(new Font("Tahoma", 0, 10));
        this.jLabelMatter.setText(ResourceManager.getString("ui.main.label.omega.matter"));
        this.jLabelMatter.setMaximumSize(new Dimension(130, 20));
        this.jLabelMatter.setMinimumSize(new Dimension(100, 20));
        this.jLabelMatter.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelMatter, gridBagConstraints);
        this.jSliderMatter.setMajorTickSpacing(25);
        this.jSliderMatter.setMaximum(200);
        this.jSliderMatter.setValue(0);
        this.jSliderMatter.setMaximumSize(new Dimension(100, 25));
        this.jSliderMatter.setMinimumSize(new Dimension(100, 25));
        this.jSliderMatter.setPreferredSize(new Dimension(100, 25));
        this.jSliderMatter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jSliderMatter, gridBagConstraints);
        this.jTextFieldMatter.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldMatter.setText("0");
        this.jTextFieldMatter.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldMatter.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldMatter.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldMatter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldMatter.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldMatter, gridBagConstraints);
        this.jLabelDarkMatter.setFont(new Font("Tahoma", 0, 10));
        this.jLabelDarkMatter.setText(ResourceManager.getString("ui.main.label.omega.darkmatter"));
        this.jLabelDarkMatter.setMaximumSize(new Dimension(130, 20));
        this.jLabelDarkMatter.setMinimumSize(new Dimension(100, 20));
        this.jLabelDarkMatter.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelDarkMatter, gridBagConstraints);
        this.jSliderDarkMatter.setMajorTickSpacing(25);
        this.jSliderDarkMatter.setMaximum(200);
        this.jSliderDarkMatter.setValue(0);
        this.jSliderDarkMatter.setMaximumSize(new Dimension(100, 25));
        this.jSliderDarkMatter.setMinimumSize(new Dimension(100, 25));
        this.jSliderDarkMatter.setPreferredSize(new Dimension(100, 25));
        this.jSliderDarkMatter.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jSliderDarkMatter, gridBagConstraints);
        this.jTextFieldDarkMatter.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldDarkMatter.setText("0");
        this.jTextFieldDarkMatter.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldDarkMatter.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldDarkMatter.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldDarkMatter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldDarkMatter.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldDarkMatter, gridBagConstraints);
        this.jLabelCosString.setFont(new Font("Tahoma", 0, 10));
        this.jLabelCosString.setText(ResourceManager.getString("ui.main.label.omega.string"));
        this.jLabelCosString.setMaximumSize(new Dimension(130, 20));
        this.jLabelCosString.setMinimumSize(new Dimension(100, 20));
        this.jLabelCosString.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelCosString, gridBagConstraints);
        this.jSliderCosString.setMajorTickSpacing(25);
        this.jSliderCosString.setMaximum(200);
        this.jSliderCosString.setValue(0);
        this.jSliderCosString.setMaximumSize(new Dimension(100, 25));
        this.jSliderCosString.setMinimumSize(new Dimension(100, 25));
        this.jSliderCosString.setPreferredSize(new Dimension(100, 25));
        this.jSliderCosString.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jSliderCosString, gridBagConstraints);
        this.jTextFieldCosString.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldCosString.setText("0");
        this.jTextFieldCosString.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldCosString.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldCosString.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldCosString.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldCosString.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldCosString, gridBagConstraints);
        this.jLabelTexture.setFont(new Font("Tahoma", 0, 10));
        this.jLabelTexture.setText(ResourceManager.getString("ui.main.label.omega.texture"));
        this.jLabelTexture.setMaximumSize(new Dimension(130, 20));
        this.jLabelTexture.setMinimumSize(new Dimension(100, 20));
        this.jLabelTexture.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelTexture, gridBagConstraints);
        this.jSliderTexture.setMajorTickSpacing(25);
        this.jSliderTexture.setMaximum(200);
        this.jSliderTexture.setValue(0);
        this.jSliderTexture.setMaximumSize(new Dimension(100, 25));
        this.jSliderTexture.setMinimumSize(new Dimension(100, 25));
        this.jSliderTexture.setPreferredSize(new Dimension(100, 25));
        this.jSliderTexture.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jSliderTexture, gridBagConstraints);
        this.jTextFieldTexture.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldTexture.setText("0");
        this.jTextFieldTexture.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldTexture.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldTexture.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldTexture.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldTexture.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldTexture, gridBagConstraints);
        this.jLabelConstant.setFont(new Font("Tahoma", 0, 10));
        this.jLabelConstant.setText(ResourceManager.getString("ui.main.label.omega.constant"));
        this.jLabelConstant.setMaximumSize(new Dimension(130, 20));
        this.jLabelConstant.setMinimumSize(new Dimension(100, 20));
        this.jLabelConstant.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jLabelConstant, gridBagConstraints);
        this.jSliderConstant.setMajorTickSpacing(25);
        this.jSliderConstant.setMaximum(400);
        this.jSliderConstant.setValue(200);
        this.jSliderConstant.setMaximumSize(new Dimension(100, 25));
        this.jSliderConstant.setMinimumSize(new Dimension(100, 25));
        this.jSliderConstant.setPreferredSize(new Dimension(100, 25));
        this.jSliderConstant.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainJFrame.this.inputJSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jSliderConstant, gridBagConstraints);
        this.jTextFieldConstant.setFont(new Font("Tahoma", 0, 10));
        this.jTextFieldConstant.setText("0");
        this.jTextFieldConstant.setMaximumSize(new Dimension(30, 20));
        this.jTextFieldConstant.setMinimumSize(new Dimension(30, 20));
        this.jTextFieldConstant.setPreferredSize(new Dimension(30, 20));
        this.jTextFieldConstant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.InputJTextFieldActionPerformed(evt);
            }
        });
        this.jTextFieldConstant.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MainJFrame.this.InputJTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        jPanelSepInputs.add((Component)this.jTextFieldConstant, gridBagConstraints);
        JPanel createResetPanel = new JPanel();
        this.jPanel1.setMaximumSize(new Dimension(0, 0));
        this.jButtonUpdate.setToolTipText(ResourceManager.getString("ui.main.button.updatetip"));
        this.jButtonUpdate.setFont(this.getFont());
        this.jButtonUpdate.setText(ResourceManager.getString("ui.main.button.update"));
        this.jButtonUpdate.setHorizontalAlignment(4);
        this.jButtonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonUpdateActionPerformed(evt);
            }
        });
        createResetPanel.add(this.jButtonUpdate);
        this.jButtonReset.setToolTipText(ResourceManager.getString("ui.main.button.resettip"));
        this.jButtonReset.setFont(this.getFont());
        this.jButtonReset.setText(ResourceManager.getString("ui.main.button.reset"));
        this.jButtonReset.setHorizontalAlignment(4);
        this.jButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonResetActionPerformed(evt);
            }
        });
        createResetPanel.add(this.jButtonReset);
        JPanel saveDataPanel = new JPanel();
        this.jButtonSaveData.setToolTipText(ResourceManager.getString("ui.main.button.savedatatip"));
        this.jButtonSaveData.setFont(this.getFont());
        this.jButtonSaveData.setText(ResourceManager.getString("ui.main.button.savedata"));
        this.jButtonSaveData.setHorizontalAlignment(4);
        this.jButtonSaveData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonSaveDataActionPerformed(evt);
            }
        });
        saveDataPanel.add(this.jButtonSaveData);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)createResetPanel, "Center");
        this.jPanel1.add((Component)saveDataPanel, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanelSepInputs.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(6, 1));
        this.jButtonLevel1.setToolTipText(ResourceManager.getString("ui.main.button.level1tip"));
        this.jButtonLevel1.setFont(this.getFont());
        this.jButtonLevel1.setText(ResourceManager.getString("ui.main.button.level1"));
        this.jButtonLevel1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ctrl.startGame(1);
            }
        });
        this.jPanel3.add(this.jButtonLevel1);
        this.jButtonLevel2.setToolTipText(ResourceManager.getString("ui.main.button.level2tip"));
        this.jButtonLevel2.setFont(this.getFont());
        this.jButtonLevel2.setText(ResourceManager.getString("ui.main.button.level2"));
        this.jButtonLevel2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ctrl.startGame(2);
            }
        });
        this.jPanel3.add(this.jButtonLevel2);
        this.jButtonLevel3.setToolTipText(ResourceManager.getString("ui.main.button.level3tip"));
        this.jButtonLevel3.setFont(this.getFont());
        this.jButtonLevel3.setText(ResourceManager.getString("ui.main.button.level3"));
        this.jButtonLevel3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ctrl.startGame(3);
            }
        });
        this.jPanel3.add(this.jButtonLevel3);
        this.jButtonLevel4.setToolTipText(ResourceManager.getString("ui.main.button.level4tip"));
        this.jButtonLevel4.setFont(this.getFont());
        this.jButtonLevel4.setText(ResourceManager.getString("ui.main.button.level4"));
        this.jButtonLevel4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ctrl.startGame(4);
            }
        });
        this.jPanel3.add(this.jButtonLevel4);
        this.jButtonLevel5.setToolTipText(ResourceManager.getString("ui.main.button.level5tip"));
        this.jButtonLevel5.setFont(this.getFont());
        this.jButtonLevel5.setText(ResourceManager.getString("ui.main.button.level5"));
        this.jButtonLevel5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ctrl.startGame(5);
            }
        });
        this.jPanel3.add(this.jButtonLevel5);
        this.jButtonStartOver.setToolTipText(ResourceManager.getString("ui.main.button.startovertip"));
        this.jButtonStartOver.setFont(this.getFont());
        this.jButtonStartOver.setText(ResourceManager.getString("ui.main.button.startover"));
        this.jButtonStartOver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonStartOverActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jButtonStartOver);
        this.jButtonHint.setToolTipText(ResourceManager.getString("ui.main.button.hinttip"));
        this.jButtonHint.setFont(this.getFont());
        this.jButtonHint.setText(ResourceManager.getString("ui.main.button.hint"));
        this.jButtonHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jButtonHintActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.jPanelInputs.add((Component)this.jPanel3, gridBagConstraints);
        this.graphTextArea = new JTextArea(4, 20);
        this.graphTextArea.setText("");
        this.graphTextArea.setEditable(false);
        this.graphTextArea.setLineWrap(true);
        this.graphTextArea.setWrapStyleWord(true);
        this.graphTextArea.setBackground(new Color(242, 244, 243));
        JPanel jPanelSepInputs2 = new JPanel();
        jPanelSepInputs2.setLayout(new BoxLayout(jPanelSepInputs2, 1));
        jPanelSepInputs2.add(jPanelSepInputs);
        jPanelSepInputs2.add(this.graphTextArea);
        JPanel jPanelSepInputsContainer = new JPanel(new FlowLayout());
        jPanelSepInputsContainer.add(jPanelSepInputs2);
        hintFrame.getContentPane().add((Component)jPanelSepInputsContainer, 0);
        this.message = new JTextArea(7, 45);
        this.message.setText(ResourceManager.getString("ui.main.mainwindow.text.initial"));
        this.message.setEditable(false);
        this.message.setLineWrap(true);
        this.message.setWrapStyleWord(true);
        this.message.setBackground(new Color(242, 244, 243));
        Dimension messageSize = new Dimension();
        messageSize.setSize(this.getInputPanelDimension().getWidth() - 20.0, this.getInputPanelDimension().getHeight() / 2.0 + 10.0);
        this.message.setPreferredSize(messageSize);
        this.jPanelInput.add((Component)this.message, "North");
        this.jPanelInput.add((Component)this.jPanelInputs, "North");
        this.jLabelIcon.setHorizontalAlignment(11);
        this.jLabelIcon.setIcon(ResourceManager.getImageIcon("global.path.image.logo"));
        this.jPanelInput.add((Component)this.jLabelIcon, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.getContentPane().add((Component)this.jPanelInput, gridBagConstraints);
        this.jMenuFile.setText(ResourceManager.getString("ui.menu.file"));
        this.jMenuItemFileStart.setText(ResourceManager.getString("ui.menu.file.start"));
        this.jMenuItemFileStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jMenuItemFileStartActionPerformed(evt);
            }
        });
        this.jMenuItemFileEnd.setText(ResourceManager.getString("ui.menu.file.end"));
        this.jMenuItemFileEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jMenuItemFileEndActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jSeparatorFile);
        this.jMenuItemFileQuit.setText(ResourceManager.getString("ui.menu.file.quit"));
        this.jMenuItemFileQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jMenuItemFileQuitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemFileQuit);
        this.jMenuBarMain.add(this.jMenuFile);
        this.jMenuHelp.setText(ResourceManager.getString("ui.menu.help"));
        this.jMenuItemHelpContents.setText(ResourceManager.getString("ui.menu.help.content"));
        this.jMenuItemHelpContents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jMenuItemHelpContentsActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpContents);
        this.jMenuItemHelpAbout.setText(ResourceManager.getString("ui.menu.help.about"));
        this.jMenuItemHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jMenuItemHelpAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuItemHelpAbout);
        this.jMenuBarMain.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBarMain);
        this.pack();
    }

    private void jButtonHintActionPerformed(ActionEvent evt) {
        this.ctrl.showHint();
    }

    private void jButtonStartOverActionPerformed(ActionEvent evt) {
        this.jMenuItemFileEndActionPerformed(evt);
    }

    private void jMenuItemFileEndActionPerformed(ActionEvent evt) {
        this.setStartEnabled(true);
        this.ctrl.endGame();
    }

    private void jButtonStartActionPerformed(ActionEvent evt) {
        this.jMenuItemFileStartActionPerformed(evt);
    }

    private void jMenuItemFileStartActionPerformed(ActionEvent evt) {
    }

    private void jMenuItemHelpAboutActionPerformed(ActionEvent evt) {
        new AboutJDialog((Frame)this, true).setVisible(true);
    }

    private void jMenuItemHelpContentsActionPerformed(ActionEvent evt) {
        try {
            URLLauncher.openURL(ResourceManager.getString("ui.help.content.url"));
        }
        catch (URLLauncherException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jMenuItemFileQuitActionPerformed(ActionEvent evt) {
        this.closeApp();
    }

    private void jButtonUpdateActionPerformed(ActionEvent evt) {
        this.ctrl.updateModel(this.redshift, this.radiation, this.matter, this.constant, this.darkMatter, this.cosString, this.texture);
    }

    private void InputJTextFieldFocusLost(FocusEvent evt) {
        this.processJTextFieldEvent((JTextField)evt.getSource());
    }

    private void InputJTextFieldActionPerformed(ActionEvent evt) {
        this.processJTextFieldEvent((JTextField)evt.getSource());
    }

    private double getTextFieldValue(String text) {
        double value = 0.0;
        try {
            value = Double.parseDouble(text);
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    private void processJTextFieldEvent(JTextField inputJTextField) {
        if (inputJTextField == this.jTextFieldRedshift) {
            this.jSliderRedshift.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 4.0));
        } else if (inputJTextField == this.jTextFieldMatter) {
            this.jSliderMatter.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 100.0));
        } else if (inputJTextField == this.jTextFieldDarkMatter) {
            this.jSliderDarkMatter.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 100.0));
        } else if (inputJTextField == this.jTextFieldCosString) {
            this.jSliderCosString.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 100.0));
        } else if (inputJTextField == this.jTextFieldRadiation) {
            this.jSliderRadiation.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 100.0));
        } else if (inputJTextField == this.jTextFieldTexture) {
            this.jSliderTexture.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 100.0));
        } else if (inputJTextField == this.jTextFieldConstant) {
            this.jSliderConstant.setValue((int)(this.getTextFieldValue(inputJTextField.getText()) * 100.0) + 200);
        }
    }

    public void setHintPaneText(String text) {
        this.hintPaneText.setText(text);
        this.hintPaneText.setHorizontalAlignment(0);
    }

    public void setMessageText(String text) {
        this.message.setText(text);
    }

    public void setMessageTextBold(boolean value) {
        if (value) {
            this.message.setFont(this.message.getFont().deriveFont(1));
        } else {
            this.message.setFont(this.message.getFont().deriveFont(0));
        }
    }

    public void setGraphText(String text) {
        this.graphTextArea.setText(text);
    }

    public void setGraphTextBold(boolean value) {
        if (value) {
            this.graphTextArea.setFont(this.graphTextArea.getFont().deriveFont(1));
        } else {
            this.graphTextArea.setFont(this.graphTextArea.getFont().deriveFont(0));
        }
    }

    public void postShowGraphEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainJFrame.this.jButtonHint.doClick();
                MainJFrame.this.ctrl.moveHintToBack();
            }
        });
    }

    public void postUpdateGraphEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainJFrame.this.jButtonUpdate.doClick();
            }
        });
    }

    private Color getErrorColor(double value, double omega) {
        float saturation = (float)(Math.log1p(Math.min(Math.abs(value - omega), 1.0)) / Math.log1p(1.0));
        return Color.getHSBColor(0.0f, saturation, 1.0f);
    }

    public boolean omegasWithinThreshold() {
        OmegaValues omegaValues = SupernovaGeneration.getOmegaValues();
        double threshold = 0.1;
        return Math.abs((double)(this.jSliderConstant.getValue() - 100) / 100.0 - omegaValues.omega_cc) < threshold && Math.abs((double)this.jSliderCosString.getValue() / 100.0 - omegaValues.omega_cs) < threshold && Math.abs((double)this.jSliderDarkMatter.getValue() / 100.0 - omegaValues.omega_dm) < threshold && Math.abs((double)this.jSliderMatter.getValue() / 100.0 - omegaValues.omega_m) < threshold && Math.abs((double)this.jSliderRadiation.getValue() / 100.0 - omegaValues.omega_r) < threshold && Math.abs((double)this.jSliderTexture.getValue() / 100.0 - omegaValues.omega_dw) < threshold;
    }

    private void inputJSliderStateChanged(ChangeEvent evt) {
        OmegaValues omegaValues = SupernovaGeneration.getOmegaValues();
        JSlider slider = (JSlider)evt.getSource();
        if (!slider.getValueIsAdjusting()) {
            double value = (double)slider.getValue() / 100.0;
            if (slider == this.jSliderConstant) {
                this.constant = value = (double)(slider.getValue() - 200) / 100.0;
                this.jTextFieldConstant.setText("" + value);
            } else if (slider == this.jSliderCosString) {
                this.cosString = value;
                this.jTextFieldCosString.setText("" + value);
            } else if (slider == this.jSliderDarkMatter) {
                this.darkMatter = value;
                this.jTextFieldDarkMatter.setText("" + value);
            } else if (slider == this.jSliderMatter) {
                this.matter = value;
                this.jTextFieldMatter.setText("" + value);
            } else if (slider == this.jSliderRadiation) {
                this.radiation = value;
                this.jTextFieldRadiation.setText("" + value);
            } else if (slider == this.jSliderRedshift) {
                this.redshift = value = (double)slider.getValue() / 4.0;
                this.jTextFieldRedshift.setText("" + value);
            } else if (slider == this.jSliderTexture) {
                this.texture = value;
                this.jTextFieldTexture.setText("" + value);
            }
        }
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.resetOmega();
    }

    private void jButtonSaveDataActionPerformed(ActionEvent evt) {
        JFileChooser choose = new JFileChooser();
        choose.setMultiSelectionEnabled(false);
        int retvalue = choose.showSaveDialog(null);
        if (retvalue == 0) {
            try {
                File file = choose.getSelectedFile();
                if (file.exists()) {
                    JOptionPane.showMessageDialog(null, "File already exists", "ERROR", 0);
                    return;
                }
                BufferedWriter bout = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(file), 32768)));
                SupernovaData[] values = SupernovaGeneration.getLastValues();
                String s = "redshift   magnitude";
                bout.write(s, 0, s.length());
                bout.newLine();
                for (int i = 0; i < values.length; ++i) {
                    s = "" + Math.rint(values[i].getRedshift() * 1000.0) / 1000.0 + "    " + Math.rint(values[i].getMagnitude() * 100.0) / 100.0;
                    bout.write(s, 0, s.length());
                    bout.newLine();
                }
                bout.flush();
                bout.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void resetOmega() {
        this.jSliderMatter.setValue(100);
        this.jSliderDarkMatter.setValue(100);
        this.jSliderCosString.setValue(100);
        this.jSliderRadiation.setValue(100);
        this.jSliderTexture.setValue(100);
        this.jSliderConstant.setValue(0);
        this.jSliderRedshift.setValue(8);
        this.jSliderMatter.setValue(0);
        this.jSliderDarkMatter.setValue(0);
        this.jSliderCosString.setValue(0);
        this.jSliderRadiation.setValue(0);
        this.jSliderTexture.setValue(0);
        this.jSliderConstant.setValue(200);
    }

    public void setCtrl(MainController ctrl) {
        this.ctrl = ctrl;
    }

    public void closeApp() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public JTabbedPane getChartsJTabbedPane() {
        return this.jTabbedPaneCharts;
    }

    public Dimension getImagePanelDimension() {
        return new Dimension(this.mainAppWinSize.width, this.mainAppWinSize.height * 13 / 30);
    }

    private Dimension getTabPanelDimension() {
        return new Dimension(this.mainAppWinSize.width * 2 / 3, this.mainAppWinSize.height * 3 / 5);
    }

    private Dimension getInputPanelDimension() {
        return new Dimension(this.mainAppWinSize.width / 3, this.mainAppWinSize.height / 3);
    }

    public void setImageJPanelContent(JComponent c) {
        this.jPanelImageHolder.removeAll();
        this.jPanelImageHolder.add(c);
        this.jPanelImageHolder.repaint();
        this.pack();
    }

    public void showButtons(int state) {
        this.jButtonLevel1.setVisible(state != 0);
        this.jButtonLevel2.setVisible(state != 0);
        this.jButtonLevel3.setVisible(state != 0);
        this.jButtonLevel4.setVisible(state != 0);
        this.jButtonLevel5.setVisible(state != 0);
        this.jButtonStartOver.setVisible(state == 0);
        this.jButtonHint.setVisible(state == 0);
    }

    public void setStartEnabled(boolean value) {
        this.jButtonLevel1.setEnabled(value);
        this.jButtonLevel2.setEnabled(value);
        this.jButtonLevel3.setEnabled(value);
        this.jButtonLevel4.setEnabled(value);
        this.jButtonLevel5.setEnabled(value);
    }
}

