/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import edu.calstatela.scivi.model.Supernova;
import edu.calstatela.scivi.util.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HintJFrame
extends JFrame {
    private BufferedImage hintImg;
    private BufferedImage initialImg;
    private BufferedImage currImg;
    private int width;
    private int height;
    private ArrayList<TargetJPanel> panelList;
    private ImageIcon icon;
    private JLabel jLabelUniverseImage;
    private JLayeredPane jLayeredPane1;

    public HintJFrame(BufferedImage initialImg, BufferedImage hintImg, double aspectRatio) {
        this.setDefaultCloseOperation(0);
        this.hintImg = hintImg;
        this.initialImg = initialImg;
        this.currImg = initialImg;
        this.width = hintImg.getWidth();
        this.height = hintImg.getHeight();
        this.panelList = new ArrayList(15);
        this.initComponents();
    }

    public int getImageWidth() {
        return this.width;
    }

    public int getImageHeight() {
        return this.height;
    }

    private void initComponents() {
        this.jLayeredPane1 = new JLayeredPane();
        this.jLabelUniverseImage = new JLabel();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.setTitle(ResourceManager.getString("ui.hint.title"));
        this.icon = new ImageIcon(this.currImg);
        this.jLabelUniverseImage.setIcon(this.icon);
        this.jLabelUniverseImage.setBounds(0, 0, this.width, this.height);
        this.jLayeredPane1.add((Component)this.jLabelUniverseImage, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPane1.setPreferredSize(new Dimension(this.width, this.height));
        this.jLayeredPane1.setSize(this.width, this.height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 790) / 2, (screenSize.height - 450) / 2, 790, 450);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent winEvt) {
                JOptionPane.showMessageDialog(null, ResourceManager.getString("ui.main.graphwindow.onclose.message"), ResourceManager.getString("ui.main.graphwindow.onclose.title"), 1);
            }
        });
    }

    public void switchImage() {
        this.icon.setImage(this.hintImg);
        this.jLayeredPane1.repaint();
    }

    public void switchImageToInitial() {
        this.icon.setImage(this.initialImg);
        this.jLayeredPane1.repaint();
    }

    public void hideTargetPanels() {
        int size = this.panelList.size();
        for (int i = 0; i < size; ++i) {
            this.panelList.get(i).setVisible(false);
        }
    }

    public void resetTargetPanelsClick() {
        int size = this.panelList.size();
        for (int i = 0; i < size; ++i) {
            this.panelList.get(i).setClicked(false);
        }
    }

    public JLayeredPane getJLayeredPane1() {
        return this.jLayeredPane1;
    }

    public void addNovaHint(int x, int y, double xScale, double yScale, Supernova nova) {
        TargetJPanel panel = new TargetJPanel(x, y, xScale, yScale, nova);
        this.jLayeredPane1.add((Component)panel, JLayeredPane.DRAG_LAYER);
        this.panelList.add(panel);
    }

    public void makeTargetPanelVisible(int x, int y) {
        int size = this.panelList.size();
        for (int i = 0; i < size; ++i) {
            TargetJPanel panel = this.panelList.get(i);
            Supernova nova = panel.getSupernova();
            if (nova.getX() != x || nova.getY() != y) continue;
            panel.setVisible(true);
            this.jLayeredPane1.repaint();
        }
    }

    public void setTargetPanelClicked(int x, int y) {
        int size = this.panelList.size();
        for (int i = 0; i < size; ++i) {
            TargetJPanel panel = this.panelList.get(i);
            Supernova nova = panel.getSupernova();
            if (nova.getX() != x || nova.getY() != y) continue;
            panel.setClicked(true);
            this.jLayeredPane1.repaint();
        }
    }

    public void recomputePanelsLocation() {
        int size = this.panelList.size();
        for (int i = 0; i < size; ++i) {
            this.panelList.get(i).recomputeLocation();
        }
    }

    private class TargetJPanel
    extends JPanel {
        private Supernova supernova;
        private double xScale;
        private double yScale;
        private boolean visible;
        private boolean isClicked;

        protected TargetJPanel(int x, int y, double xScale, double yScale, Supernova nova) {
            this.supernova = nova;
            this.xScale = xScale;
            this.yScale = yScale;
            this.setBounds(x - 4, y - 4, 8, 8);
            this.visible = false;
            this.isClicked = false;
        }

        public Supernova getSupernova() {
            return this.supernova;
        }

        public void recomputeLocation() {
            int scaledX = (int)(this.xScale * (double)this.supernova.getX());
            int scaledY = (int)(this.yScale * (double)this.supernova.getY());
            this.setBounds(scaledX - 4, scaledY - 4, 8, 8);
        }

        public void setVisible(boolean value) {
            this.visible = value;
        }

        public void setClicked(boolean value) {
            this.isClicked = value;
        }

        public void paintComponent(Graphics g) {
            this.recomputeLocation();
            if (this.visible) {
                if (!this.isClicked) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.GREEN);
                }
                g.drawOval(1, 1, 6, 6);
                g.drawOval(3, 3, 2, 2);
            }
        }
    }
}

