/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartsJPanel
extends JPanel {
    private JFreeChart magnitude = null;
    private Dimension chartsSize = null;
    private XYSeries supernovaSeries = null;
    private ChartPanel magCJPanel;
    private ChartPanel timeCJPanel;
    private ChartPanel baseCJPanel;
    private int width;
    private int height;

    public ChartsJPanel(Dimension size, JFreeChart mag, JFreeChart time, JFreeChart base, String descString) {
        this.width = (int)size.getWidth();
        this.height = (int)size.getHeight();
        this.magnitude = mag;
        this.supernovaSeries = ((XYSeriesCollection)mag.getXYPlot().getDataset()).getSeries(1);
        this.magCJPanel = new ChartPanel(mag, this.width, this.height, this.width, this.height, this.width, this.height, true, true, true, true, true, true);
        this.timeCJPanel = new ChartPanel(time, this.width, this.height, this.width, this.height, this.width, this.height, true, true, true, true, true, true);
        this.baseCJPanel = new ChartPanel(base, this.width, this.height, this.width, this.height, this.width, this.height, true, true, true, true, true, true);
        JLabel desc = new JLabel(descString);
        desc.setAlignmentX(0.0f);
        desc.setBackground(this.getBackground());
        desc.setFont(new Font("Tahoma", 0, 10));
        desc.setSize(this.width, 20);
        JPanel bottomPanel = new JPanel();
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add((Component)this.timeCJPanel, "North");
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add((Component)leftPanel, "West");
        bottomPanel.add((Component)rightPanel, "East");
        leftPanel.add(this.magCJPanel);
        this.add((Component)desc, "North");
        this.add((Component)bottomPanel, "South");
        this.setVisible(true);
    }

    public ChartPanel getMagPanel() {
        return this.magCJPanel;
    }

    public ChartPanel getCopyMagPanel() {
        JFreeChart chart = this.magCJPanel.getChart();
        return new ChartPanel(chart, this.width, this.height, this.width, this.height, this.width, this.height, true, true, true, true, true, true);
    }

    public ChartPanel getTimePanel() {
        return this.timeCJPanel;
    }

    public ChartPanel getBasePanel() {
        return this.baseCJPanel;
    }

    public void addSupernovaPlotPoint(double magnitude, double redshift) {
        this.supernovaSeries.add(redshift, magnitude);
    }

    public JFreeChart getMagnitude() {
        return this.magnitude;
    }
}

