/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.Supernova;
import edu.calstatela.scivi.model.helper.SupernovaData;
import edu.calstatela.scivi.model.helper.SupernovaGeneration;
import edu.calstatela.scivi.model.helper.SupernovaReaderException;
import edu.calstatela.scivi.util.ResourceManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupernovaReader {
    public List<Supernova> readSupernovaes(String filename) throws SupernovaReaderException {
        LinkedList<Supernova> novaes = new LinkedList<Supernova>();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
        String line = null;
        int novaCount = 0;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 1) continue;
                Supernova nova = this.parseNova(line);
                nova.setID(novaCount);
                novaes.add(nova);
            }
        }
        catch (IOException ioe) {
            String errMsg = ResourceManager.getString("error.file.read");
            Object[] arg = new Object[]{filename};
            throw new SupernovaReaderException(MessageFormat.format(errMsg, arg));
        }
        return novaes;
    }

    private Supernova parseNova(String line) throws SupernovaReaderException {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() != 4) {
            throw new SupernovaReaderException(ResourceManager.getString("error.supernova.parse"));
        }
        Supernova nova = new Supernova();
        try {
            nova.setX(Integer.parseInt(st.nextToken()));
            nova.setY(Integer.parseInt(st.nextToken()));
            nova.setRedShift(Double.parseDouble(st.nextToken()));
            nova.setMagnitude(Double.parseDouble(st.nextToken()));
        }
        catch (NumberFormatException ex) {
            throw new SupernovaReaderException(ResourceManager.getString("error.supernova.parse"));
        }
        return nova;
    }

    private Supernova parseSupernovaData(SupernovaData supernova) {
        Supernova nova = new Supernova();
        nova.setX((int)supernova.getX());
        nova.setY((int)supernova.getY());
        nova.setMagnitude(supernova.getGraphYAxis());
        nova.setRedShift(supernova.getRedshift());
        nova.setRadius(supernova.getRadius());
        System.out.println("nova--x: " + nova.getX() + "; y: " + nova.getY() + "; mag: " + nova.getMagnitude() + "; redshift: " + nova.getRedShift() + "; radius: " + nova.getRadius());
        return nova;
    }

    public List<Supernova> convertSupernovaData(int level, String filename) throws SupernovaReaderException {
        String omegaFilename;
        LinkedList<Supernova> novaes = new LinkedList<Supernova>();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(filename);
        int novaCount = 0;
        switch (level) {
            case 1: {
                omegaFilename = ResourceManager.getString("global.path.data.omega.parameters.level1");
                break;
            }
            case 2: {
                omegaFilename = ResourceManager.getString("global.path.data.omega.parameters.level2");
                break;
            }
            case 3: {
                omegaFilename = ResourceManager.getString("global.path.data.omega.parameters.level3");
                break;
            }
            case 4: {
                omegaFilename = ResourceManager.getString("global.path.data.omega.parameters.level4");
                break;
            }
            case 5: {
                omegaFilename = ResourceManager.getString("global.path.data.omega.parameters.level5");
                break;
            }
            default: {
                String errMsg = ResourceManager.getString("error.omega.levels");
                throw new SupernovaReaderException(errMsg);
            }
        }
        System.out.println("filename: " + filename);
        System.out.println("omega filename: " + omegaFilename);
        InputStream is_omega = this.getClass().getClassLoader().getResourceAsStream(omegaFilename);
        try {
            SupernovaData[] supernovas = SupernovaGeneration.getSupernovas(is_omega, is, level);
            int length = supernovas.length;
            for (int i = 0; i < length; ++i) {
                Supernova nova = this.parseSupernovaData(supernovas[i]);
                nova.setID(novaCount);
                novaes.add(nova);
                ++novaCount;
            }
        }
        catch (IOException ex) {
            String errMsg = ResourceManager.getString("error.file.read");
            Object[] arg = new Object[]{filename};
            throw new SupernovaReaderException(MessageFormat.format(errMsg, arg));
        }
        return novaes;
    }

    public static double findSupernovaMaxRadius(List<Supernova> list) {
        Iterator<Supernova> it = list.iterator();
        double maxRadius = 0.0;
        boolean start = true;
        while (it.hasNext()) {
            Supernova nova;
            if (start) {
                nova = it.next();
                maxRadius = nova.getRadius();
                start = false;
                continue;
            }
            nova = it.next();
            if (!(nova.getRadius() > maxRadius)) continue;
            maxRadius = nova.getRadius();
        }
        return maxRadius;
    }

    public static double findSupernovaMinRadius(List<Supernova> list) {
        Iterator<Supernova> it = list.iterator();
        double minRadius = 0.0;
        boolean start = true;
        while (it.hasNext()) {
            Supernova nova;
            if (start) {
                nova = it.next();
                minRadius = nova.getRadius();
                start = false;
                continue;
            }
            nova = it.next();
            if (!(nova.getRadius() < minRadius)) continue;
            minRadius = nova.getRadius();
        }
        return minRadius;
    }
}

