/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.CustomMath;
import edu.calstatela.scivi.model.OmegaValues;
import edu.calstatela.scivi.model.RedShiftMagnitude;
import edu.calstatela.scivi.model.helper.SupernovaData;
import edu.calstatela.scivi.model.helper.UDFComparator;
import edu.calstatela.scivi.model.helper.UDFInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupernovaGeneration {
    private static OmegaValues omegaValues;
    private static int level1;
    private static int level2;
    private static int level3;
    private static int level4;
    private static SupernovaData[] lastValues;

    private SupernovaGeneration() {
    }

    public static String removeComment(String line) {
        int index = line.indexOf("#");
        if (index < 0) {
            return line;
        }
        return line.substring(0, index);
    }

    public static UDFInfo readUDFInfo(String line) {
        UDFInfo udfinfo = new UDFInfo();
        String[] values = line.trim().split("\\s+");
        double x = Double.parseDouble(values[0]);
        double y = Double.parseDouble(values[1]);
        double xjpeg = 0.344816553391 * x + -0.363246191939 * y + 1632.79982889;
        double yjpeg = -0.361575914478 * x + -0.345053879636 * y + 4571.62595015;
        double radius = Double.parseDouble(values[2]);
        if (xjpeg > 3100.0 || xjpeg < 0.0 || yjpeg < 0.0 || yjpeg > 1301.0) {
            return null;
        }
        udfinfo.setX(xjpeg);
        udfinfo.setY(yjpeg);
        udfinfo.setMag(Double.parseDouble(values[4]));
        udfinfo.setFWHM(Double.parseDouble(values[3]) * 0.5);
        udfinfo.setRadius(radius);
        return udfinfo;
    }

    public static ArrayList<UDFInfo> readUDF(InputStream input) throws IOException {
        String line;
        BufferedReader bin = new BufferedReader(new InputStreamReader(input), 524288);
        ArrayList<UDFInfo> result = new ArrayList<UDFInfo>(3000);
        do {
            UDFInfo udfinfo;
            if ((line = bin.readLine()) == null || (line = SupernovaGeneration.removeComment(line)).length() <= 0 || (udfinfo = SupernovaGeneration.readUDFInfo(line)) == null) continue;
            result.add(udfinfo);
        } while (line != null);
        bin.close();
        System.out.println("udfinfo size: " + result.size());
        return result;
    }

    public static int[] udfBinaryRangeSearch(ArrayList<UDFInfo> udfinfo, double lowValue, double highValue, int low, int high) {
        int i;
        int index;
        double magValue;
        int tempLow = low;
        int tempHigh = high;
        int med = tempLow + (tempHigh - tempLow) / 2;
        int[] returnIndex = new int[2];
        boolean[] flags = new boolean[]{false, false};
        while (tempLow <= tempHigh) {
            magValue = udfinfo.get(med).getCompareValue();
            if (magValue < lowValue) {
                tempLow = med + 1;
            } else if (magValue > lowValue) {
                tempHigh = med - 1;
            } else {
                returnIndex[0] = med;
                flags[0] = true;
                break;
            }
            med = tempLow + (tempHigh - tempLow) / 2;
        }
        if (!flags[0]) {
            index = med - 1;
            if (index < low) {
                index = low;
            } else if (index > high) {
                index = high;
            }
            for (i = 0; i < 3; ++i) {
                if (udfinfo.get(index).getCompareValue() < lowValue) {
                    if (++index <= high) continue;
                    break;
                }
                flags[0] = true;
                returnIndex[0] = index;
                break;
            }
        }
        tempLow = low;
        tempHigh = high;
        med = tempLow + (tempHigh - tempLow) / 2;
        while (tempLow <= tempHigh) {
            magValue = udfinfo.get(med).getCompareValue();
            if (magValue < highValue) {
                tempLow = med + 1;
            } else if (magValue > highValue) {
                tempHigh = med - 1;
            } else {
                returnIndex[1] = med;
                flags[1] = true;
                break;
            }
            med = tempLow + (tempHigh - tempLow) / 2;
        }
        if (!flags[1]) {
            index = med + 1;
            if (index > high) {
                index = high;
            } else if (index < low) {
                index = low;
            }
            for (i = 0; i < 3; ++i) {
                if (udfinfo.get(index).getCompareValue() > highValue) {
                    if (--index >= low) continue;
                    break;
                }
                flags[1] = true;
                returnIndex[1] = index;
                break;
            }
        }
        if (flags[0] && flags[1]) {
            if (returnIndex[0] <= returnIndex[1]) {
                return returnIndex;
            }
            return null;
        }
        return null;
    }

    static int getHighestBitPosition(int num) {
        int count = 0;
        while (num > 0) {
            num >>>= 1;
            ++count;
        }
        return count;
    }

    static int powerOfTwo(int exponent) {
        int num = 1;
        int count = exponent;
        if (count >= 31) {
            return Integer.MAX_VALUE;
        }
        if (count > 0) {
            num <<= exponent;
        }
        return num;
    }

    public static OmegaValues generate(SupernovaData[] supernovas, int level, ArrayList<Double[]> omegaInfo, ArrayList<UDFInfo> udfInfo) {
        int universe_select;
        Random rand = new Random();
        double[][] results = new double[1005][2];
        int counter = 0;
        boolean[] galaxyOccupied = new boolean[udfInfo.size()];
        switch (level) {
            case 1: {
                universe_select = level1++;
                if (level1 < omegaInfo.size()) break;
                level1 = 0;
                break;
            }
            case 2: {
                universe_select = rand.nextInt(omegaInfo.size());
                break;
            }
            case 3: {
                universe_select = level3++;
                if (level3 < omegaInfo.size()) break;
                level3 = 0;
                break;
            }
            case 4: {
                universe_select = rand.nextInt(omegaInfo.size());
                break;
            }
            case 5: {
                universe_select = rand.nextInt(omegaInfo.size());
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong level");
            }
        }
        Double[] selection = omegaInfo.get(universe_select);
        double omega_r = selection[0];
        double omega_m = selection[1];
        double omega_dm = selection[2];
        double omega_cs = selection[3];
        double omega_dw = selection[4];
        double omega_cc = selection[5];
        double total_omega = omega_r + omega_m + omega_dm + omega_cs + omega_dw + omega_cc;
        System.out.println("omega_r: " + omega_r + "; omega_m: " + omega_m + "; omega_dm: " + omega_dm + "; omega_cs: " + omega_cs + "; omega_dw: " + omega_dw + "; omega_cc: " + omega_cc);
        double range = RedShiftMagnitude.calculateSupernovaData(2.0, omega_r, omega_m, omega_dm, omega_cs, omega_dw, omega_cc, results);
        System.out.println("range: " + range);
        for (int i = 0; i < 12; ++i) {
            int index = rand.nextInt(800) + 200;
            double delta_m = rand.nextGaussian() * 0.05 * range;
            System.out.println("delta_m: " + delta_m);
            double m_obs = results[index][1] + delta_m;
            double m_galaxy = 0.8931 * m_obs + 3.5967;
            double radius = 12.67 * Math.pow(10.0, 0.2 * (24.42 - m_obs));
            double temp = 1.0 + results[index][0];
            double graphYAxis = m_obs - (24.167 + 5.0 * CustomMath.log10(0.5 * (temp * temp - 1.0)));
            double radius_galaxy = 1.0 * radius;
            int[] resultIndex = radius_galaxy < 30.0 ? SupernovaGeneration.udfBinaryRangeSearch(udfInfo, radius_galaxy - 3.0, radius_galaxy + 3.0, 0, udfInfo.size() - 1) : SupernovaGeneration.udfBinaryRangeSearch(udfInfo, radius_galaxy - 4.0, radius_galaxy + 4.0, 0, udfInfo.size() - 1);
            if (resultIndex == null) {
                throw new RuntimeException("No galaxy found for this supernova; omega_r: " + omega_r + "; omega_m: " + omega_m + "; omega_dm: " + omega_dm + "; omega_cs: " + omega_cs + "; omega_dw: " + omega_dw + "; omega_cc: " + omega_cc + "; lum: " + results[index][1] + "; z: " + results[index][0] + "; m_obs: " + m_obs + "; m_galaxy: " + m_galaxy + "; radius: " + radius + "; graphYAxis: " + graphYAxis);
            }
            int udf_choices = resultIndex[1] - resultIndex[0] + 1;
            System.out.println("udf_choices: " + udf_choices);
            int choice_range = rand.nextInt(SupernovaGeneration.powerOfTwo(udf_choices) - 1) + 1;
            int galaxyIndex = resultIndex[1] - (udf_choices >= 31 ? 31 : udf_choices) + SupernovaGeneration.getHighestBitPosition(choice_range);
            for (int k = 0; k < 31 && galaxyOccupied[galaxyIndex]; ++k) {
                --galaxyIndex;
            }
            galaxyOccupied[galaxyIndex] = true;
            System.out.println("resultIndex[0]: " + resultIndex[0] + "; radius: " + udfInfo.get(resultIndex[0]).getRadius());
            System.out.println("resultIndex[1]: " + resultIndex[1] + "; radius: " + udfInfo.get(resultIndex[1]).getRadius());
            System.out.println("galaxyIndex: " + galaxyIndex + "; radius: " + udfInfo.get(galaxyIndex).getRadius());
            UDFInfo curUDFInfo = udfInfo.get(galaxyIndex);
            temp = curUDFInfo.getRadius() * 0.05;
            double dx = rand.nextGaussian() * temp;
            double dy = rand.nextGaussian() * temp;
            SupernovaData curSupernovaData = supernovas[counter];
            curSupernovaData.setX(curUDFInfo.getX() + dx);
            curSupernovaData.setY(curUDFInfo.getY() + dy);
            curSupernovaData.setMagnitude(m_obs);
            curSupernovaData.setRadius(radius);
            curSupernovaData.setGraphYAxis(graphYAxis);
            curSupernovaData.setRedshift(results[index][0]);
            ++counter;
        }
        return new OmegaValues(omega_r, omega_m, omega_dm, omega_cs, omega_dw, omega_cc);
    }

    private static Double[] readOmegaInfo(String line) {
        Double[] result = new Double[6];
        String[] values = line.trim().split("\\s+");
        for (int i = 0; i < 6; ++i) {
            result[i] = Double.parseDouble(values[i]);
        }
        return result;
    }

    private static ArrayList<Double[]> readOmega(InputStream input_omega) throws IOException {
        String line;
        BufferedReader bin = new BufferedReader(new InputStreamReader(input_omega), 524288);
        ArrayList<Double[]> result = new ArrayList<Double[]>(40);
        do {
            Double[] omegaInfo;
            if ((line = bin.readLine()) == null || (line = SupernovaGeneration.removeComment(line).trim()).length() <= 0 || (omegaInfo = SupernovaGeneration.readOmegaInfo(line)) == null) continue;
            result.add(omegaInfo);
        } while (line != null);
        bin.close();
        System.out.println("omegaInfo size: " + result.size());
        return result;
    }

    public static SupernovaData[] getSupernovas(InputStream input_omega, InputStream input, int level) throws IOException {
        int i;
        ArrayList<UDFInfo> udfinfo = SupernovaGeneration.readUDF(input);
        ArrayList<Double[]> omegaInfo = SupernovaGeneration.readOmega(input_omega);
        SupernovaData[] supernovas = new SupernovaData[12];
        for (i = 0; i < 12; ++i) {
            supernovas[i] = new SupernovaData();
        }
        Collections.sort(udfinfo, new UDFComparator());
        omegaValues = SupernovaGeneration.generate(supernovas, level, omegaInfo, udfinfo);
        lastValues = supernovas;
        for (i = 0; i < 12; ++i) {
            System.out.println("x: " + supernovas[i].getX() + " y: " + supernovas[i].getY() + " Mag: " + supernovas[i].getMagnitude() + " R: " + supernovas[i].getRadius() + " GraphYAxis: " + supernovas[i].getGraphYAxis() + " redshift: " + supernovas[i].getRedshift());
        }
        return supernovas;
    }

    public static OmegaValues getOmegaValues() {
        return omegaValues;
    }

    public static SupernovaData[] getLastValues() {
        return lastValues;
    }

    static {
        level1 = 0;
        level2 = 0;
        level3 = 0;
        level4 = 0;
    }
}

