/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.helper.NumericalDifferentialEquation;

abstract class RungeKuttaFehlberg
extends NumericalDifferentialEquation {
    RungeKuttaFehlberg() {
    }

    public int solve(double lower, double upper, double tolerance, double minStepSize, double maxStepSize, double[] resultT, double[] resultY, double[] resultDyDt) {
        double stepSize = 0.5 * (minStepSize + maxStepSize);
        double t = lower;
        double y = this.initialValue(t);
        boolean useMinStep = false;
        int count = 0;
        resultT[count] = t;
        resultY[count] = y;
        ++count;
        while (t < upper) {
            double k6;
            double k5;
            double k4;
            double k2;
            double k3;
            double k1 = this.function(y, t);
            double r = Math.abs(0.002777777777777778 * k1 - 0.02994152046783626 * (k3 = this.function(y + stepSize * (0.09375 * k1 + 0.28125 * (k2 = this.function(y + stepSize * 0.25 * k1, t + 0.25 * stepSize))), t + 0.375 * stepSize)) - 0.029199893673577886 * (k4 = this.function(y + stepSize * (0.8793809740555303 * k1 - 3.277196176604461 * k2 + 3.3208921256258535 * k3), t + 0.9230769230769231 * stepSize)) + 0.02 * (k5 = this.function(y + stepSize * (2.0324074074074074 * k1 - 8.0 * k2 + 7.173489278752436 * k3 - 0.20589668615984405 * k4), t + stepSize)) + 0.03636363636363636 * (k6 = this.function(y + stepSize * (-0.2962962962962963 * k1 + 2.0 * k2 - 1.3816764132553607 * k3 + 0.4529727095516569 * k4 - 0.275 * k5), t + 0.5 * stepSize)));
            if (r < tolerance) {
                resultDyDt[count - 1] = k1;
                resultT[count] = t += stepSize;
                resultY[count] = y += stepSize * (0.11574074074074074 * k1 + 0.5489278752436647 * k3 + 0.5353313840155945 * k4 - 0.2 * k5);
                ++count;
            } else if (useMinStep) {
                resultDyDt[count - 1] = k1;
                useMinStep = false;
                resultT[count] = t += stepSize;
                resultY[count] = y += stepSize * (0.11574074074074074 * k1 + 0.5489278752436647 * k3 + 0.5353313840155945 * k4 - 0.2 * k5);
                ++count;
            }
            double stepSizeMultiplier = 0.84 * Math.sqrt(Math.sqrt(tolerance / r));
            stepSize = stepSizeMultiplier <= 0.1 ? 0.1 * stepSize : (stepSizeMultiplier > 4.0 ? 4.0 * stepSize : stepSizeMultiplier * stepSize);
            if (stepSize > maxStepSize) {
                stepSize = maxStepSize;
            } else if (stepSize < minStepSize) {
                stepSize = minStepSize;
                useMinStep = true;
            }
            if (!(t + stepSize > upper)) continue;
            stepSize = upper - t;
        }
        resultDyDt[count - 1] = this.function(y, t);
        return count;
    }
}

