/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.helper.NumericalDifferentialEquation;

abstract class RungeKutta
extends NumericalDifferentialEquation {
    RungeKutta() {
    }

    public void solve(double lower, double upper, int subdivisions, double[] resultT, double[] resultY, double[] resultDyDt) {
        double stepSize = (upper - lower) / (double)subdivisions;
        double t = lower;
        double y = this.initialValue(t);
        int count = 0;
        resultT[count] = t;
        resultY[count] = y;
        ++count;
        for (int i = 0; i < subdivisions; ++i) {
            double k1 = this.function(y, t);
            double k2 = this.function(y + 0.5 * stepSize * k1, t + 0.5 * stepSize);
            double k3 = this.function(y + 0.5 * stepSize * k2, t + 0.5 * stepSize);
            double k4 = this.function(y + stepSize * k3, t + stepSize);
            resultDyDt[count - 1] = k1;
            resultT[count] = t += stepSize;
            resultY[count] = y += stepSize / 6.0 * (k1 + 2.0 * k2 + 2.0 * k3 + k4);
            ++count;
        }
        resultDyDt[count - 1] = this.function(y, t);
    }
}

