/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.helper.BasicGaussian;

abstract class NumericalIntegration {
    private double lower;
    private double upper;
    private Gaussian gauss = new Gaussian();

    NumericalIntegration() {
    }

    abstract double function(double var1);

    public double integrate(double lower, double upper, int subdivisions, int choice) {
        double sum = 0.0;
        double increment = (upper - lower) / (double)subdivisions;
        for (int i = 0; i < subdivisions; ++i) {
            this.lower = lower + (double)i * increment;
            this.upper = lower + (double)(i + 1) * increment;
            this.gauss.setCoeff();
            sum += 0.5 * increment * this.gauss.basicGaussianQuadrature(choice);
        }
        return sum;
    }

    private class Gaussian
    extends BasicGaussian {
        private double coeff1;
        private double coeff2;

        Gaussian() {
        }

        void setCoeff() {
            this.coeff1 = (NumericalIntegration.this.upper - NumericalIntegration.this.lower) / 2.0;
            this.coeff2 = (NumericalIntegration.this.upper + NumericalIntegration.this.lower) / 2.0;
        }

        double func(double x) {
            return NumericalIntegration.this.function(this.coeff1 * x + this.coeff2);
        }
    }
}

