/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

public class EquationSolveJenkinTraub {
    private static final double DBL_MIN = Double.MIN_NORMAL;
    private static final double DBL_MAX = Double.MAX_VALUE;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double RADFAC = Math.PI / 180;
    private static final double lb2 = Math.log(2.0);
    private static final double lo = 1.0020841800044864E-292;
    private static final double cosr = Math.cos(1.6406094968746698);
    private static final double sinr = Math.sin(1.6406094968746698);
    private static final double SQRT_DBL_EPSILON = Math.sqrt(2.220446049250313E-16);
    private static final double SQRT_ONE_HALF = Math.sqrt(0.5);

    public static double[][] polySolve(double[] coeff) {
        int i;
        int size = coeff.length;
        int degree = coeff.length - 1;
        for (i = 0; i < size && coeff[i] == 0.0; ++i) {
            --degree;
        }
        double[][] zeroes = new double[2][degree];
        double[] zeror = zeroes[0];
        double[] zeroi = zeroes[1];
        double[] coeff2 = new double[degree + 1];
        for (i = degree; i >= 0; --i) {
            coeff2[i] = coeff[size - degree - 1 + i];
        }
        EquationSolveJenkinTraub.rpoly(coeff2, zeror, zeroi);
        return zeroes;
    }

    private static int rpoly(double[] coeff, double[] zeror, double[] zeroi) {
        if (coeff.length != zeror.length + 1 || zeror.length != zeroi.length) {
            throw new IllegalArgumentException("Wrong parameters");
        }
        int Degree = zeror.length;
        IntNum NZ = new IntNum();
        double[] K = new double[coeff.length];
        double[] p = new double[coeff.length];
        double[] pt = new double[coeff.length];
        double[] qp = new double[coeff.length];
        double[] temp = new double[coeff.length];
        DoubleNum lzi = new DoubleNum();
        DoubleNum lzr = new DoubleNum();
        DoubleNum szi = new DoubleNum();
        DoubleNum szr = new DoubleNum();
        DoubleNum zeror1 = new DoubleNum();
        DoubleNum zeroi1 = new DoubleNum();
        DoubleNum zeror2 = new DoubleNum();
        DoubleNum zeroi2 = new DoubleNum();
        if (coeff[0] != 0.0) {
            int i;
            int N = Degree;
            double xx = SQRT_ONE_HALF;
            double yy = -xx;
            int j = 0;
            while (coeff[N] == 0.0) {
                zeroi[j] = 0.0;
                zeror[j] = 0.0;
                --N;
                ++j;
            }
            int NN = N + 1;
            for (i = 0; i < NN; ++i) {
                p[i] = coeff[i];
            }
            while (N >= 1) {
                int jj;
                double df;
                double ff;
                double xm;
                int l;
                double factor;
                double x;
                if (N <= 2) {
                    if (N < 2) {
                        zeror[Degree - 1] = -(p[1] / p[0]);
                        zeroi[Degree - 1] = 0.0;
                    } else {
                        EquationSolveJenkinTraub.Quad(p[0], p[1], p[2], zeror2, zeroi2, zeror1, zeroi1);
                        zeror[Degree - 2] = zeror2.val;
                        zeroi[Degree - 2] = zeroi2.val;
                        zeror[Degree - 1] = zeror1.val;
                        zeroi[Degree - 1] = zeroi1.val;
                    }
                    break;
                }
                double moduli_max = 0.0;
                double moduli_min = Double.MAX_VALUE;
                for (i = 0; i < NN; ++i) {
                    x = Math.abs(p[i]);
                    if (x > moduli_max) {
                        moduli_max = x;
                    }
                    if (x == 0.0 || !(x < moduli_min)) continue;
                    moduli_min = x;
                }
                double sc = 1.0020841800044864E-292 / moduli_min;
                if ((sc <= 1.0 && moduli_max >= 10.0 || sc > 1.0 && Double.MAX_VALUE / sc >= moduli_max) && (factor = Math.pow(2.0, l = (int)(Math.log(sc = sc == 0.0 ? Double.MIN_NORMAL : sc) / lb2 + 0.5))) != 1.0) {
                    i = 0;
                    while (i < NN) {
                        int n = i++;
                        p[n] = p[n] * factor;
                    }
                }
                for (i = 0; i < NN; ++i) {
                    pt[i] = Math.abs(p[i]);
                }
                pt[N] = -pt[N];
                int NM1 = N - 1;
                x = Math.exp((Math.log(-pt[N]) - Math.log(pt[0])) / (double)N);
                if (pt[NM1] != 0.0) {
                    xm = -pt[N] / pt[NM1];
                    x = xm < x ? xm : x;
                }
                xm = x;
                do {
                    x = xm;
                    xm = 0.1 * x;
                    ff = pt[0];
                    for (i = 1; i < NN; ++i) {
                        ff = ff * xm + pt[i];
                    }
                } while (ff > 0.0);
                double dx = x;
                do {
                    df = ff = pt[0];
                    for (i = 1; i < N; ++i) {
                        ff = x * ff + pt[i];
                        df = x * df + ff;
                    }
                } while (Math.abs((dx = (ff = x * ff + pt[N]) / df) / (x -= dx)) > 0.005);
                double bnd = x;
                for (i = 1; i < N; ++i) {
                    K[i] = (double)(N - i) * p[i] / (double)N;
                }
                K[0] = p[0];
                double aa = p[N];
                double bb = p[NM1];
                boolean zerok = K[NM1] == 0.0;
                for (jj = 0; jj < 5; ++jj) {
                    double cc = K[NM1];
                    if (zerok) {
                        for (i = 0; i < NM1; ++i) {
                            j = NM1 - i;
                            K[j] = K[j - 1];
                        }
                        K[0] = 0.0;
                        zerok = K[NM1] == 0.0;
                        continue;
                    }
                    double t = -aa / cc;
                    for (i = 0; i < NM1; ++i) {
                        j = NM1 - i;
                        K[j] = t * K[j - 1] + p[j];
                    }
                    K[0] = p[0];
                    zerok = Math.abs(K[NM1]) <= Math.abs(bb) * 2.220446049250313E-16 * 10.0;
                }
                for (i = 0; i < N; ++i) {
                    temp[i] = K[i];
                }
                for (jj = 1; jj <= 50; ++jj) {
                    double xxx = -(sinr * yy) + cosr * xx;
                    yy = sinr * xx + cosr * yy;
                    xx = xxx;
                    double sr = bnd * xx;
                    double u = -(2.0 * sr);
                    EquationSolveJenkinTraub.Fxshfr(50 * jj, NZ, sr, bnd, K, N, p, NN, qp, u, lzi, lzr, szi, szr);
                    if (NZ.val != 0) {
                        j = Degree - N;
                        zeror[j] = szr.val;
                        zeroi[j] = szi.val;
                        N = (NN -= NZ.val) - 1;
                        for (i = 0; i < NN; ++i) {
                            p[i] = qp[i];
                        }
                        if (NZ.val == 1) break;
                        zeror[j + 1] = lzr.val;
                        zeroi[j + 1] = lzi.val;
                        break;
                    }
                    for (i = 0; i < N; ++i) {
                        K[i] = temp[i];
                    }
                }
                if (jj <= 50) continue;
                Degree -= N;
                throw new RuntimeException("Failure in Jenkin-Traub. No convergence after 50 shifts. Function terminated.");
            }
        } else {
            Degree = 0;
            throw new IllegalArgumentException("The leading coefficient is zero. Function terminated.");
        }
        return Degree;
    }

    private static void Fxshfr(int L2, IntNum NZ, double sr, double v, double[] K, int N, double[] p, int NN, double[] qp, double u, DoubleNum lzi, DoubleNum lzr, DoubleNum szi, DoubleNum szr) {
        if (K.length != p.length || p.length != qp.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        IntNum iFlag = new IntNum();
        iFlag.val = 1;
        double ots = 0.0;
        double otv = 0.0;
        double[] qk = new double[K.length];
        double[] svk = new double[K.length];
        DoubleNum a = new DoubleNum();
        DoubleNum b = new DoubleNum();
        DoubleNum a1 = new DoubleNum();
        DoubleNum a3 = new DoubleNum();
        DoubleNum a7 = new DoubleNum();
        DoubleNum c = new DoubleNum();
        DoubleNum d = new DoubleNum();
        DoubleNum e = new DoubleNum();
        DoubleNum f = new DoubleNum();
        DoubleNum g = new DoubleNum();
        DoubleNum h = new DoubleNum();
        DoubleNum ui = new DoubleNum();
        DoubleNum vi = new DoubleNum();
        DoubleNum s = new DoubleNum();
        NZ.val = 0;
        double betas = 0.25;
        double betav = 0.25;
        double oss = sr;
        double ovv = v;
        EquationSolveJenkinTraub.QuadSD(NN, u, v, p, qp, a, b);
        int tFlag = EquationSolveJenkinTraub.calcSC(N, a.val, b.val, a1, a3, a7, c, d, e, f, g, h, K, u, v, qk);
        for (int j = 0; j < L2; ++j) {
            double ts;
            double tv;
            double ss;
            double vv;
            block15: {
                int i;
                boolean spass;
                boolean fflag = true;
                EquationSolveJenkinTraub.nextK(N, tFlag, a.val, b.val, a1.val, a3, a7, K, qk, qp);
                tFlag = EquationSolveJenkinTraub.calcSC(N, a.val, b.val, a1, a3, a7, c, d, e, f, g, h, K, u, v, qk);
                EquationSolveJenkinTraub.newest(tFlag, ui, vi, a.val, a1.val, a3.val, a7.val, b.val, c.val, d.val, f.val, g.val, h.val, u, v, K, N, p);
                vv = vi.val;
                ss = K[N - 1] != 0.0 ? -(p[N] / K[N - 1]) : 0.0;
                tv = 1.0;
                ts = 1.0;
                if (j == 0 || tFlag == 3) break block15;
                tv = vv != 0.0 ? Math.abs((vv - ovv) / vv) : tv;
                ts = ss != 0.0 ? Math.abs((ss - oss) / ss) : ts;
                double tvv = tv < otv ? tv * otv : 1.0;
                double tss = ts < ots ? ts * ots : 1.0;
                boolean vpass = tvv < betav;
                boolean bl = spass = tss < betas;
                if (!spass && !vpass) break block15;
                for (i = 0; i < N; ++i) {
                    svk[i] = K[i];
                }
                s.val = ss;
                int vtry = 0;
                int stry = 0;
                while (true) {
                    block17: {
                        block16: {
                            if (!fflag) break block16;
                            fflag = false;
                            if (!false && spass && (!vpass || tss < tvv)) break block17;
                        }
                        EquationSolveJenkinTraub.QuadIT(N, NZ, ui.val, vi.val, szr, szi, lzr, lzi, qp, NN, a, b, p, qk, a1, a3, a7, c, d, e, f, g, h, K);
                        if (NZ.val > 0) {
                            return;
                        }
                        vtry = 1;
                        iFlag.val = 1;
                        betav *= 0.25;
                        if (stry == 1 || !spass) {
                            iFlag.val = 0;
                        } else {
                            for (i = 0; i < N; ++i) {
                                K[i] = svk[i];
                            }
                        }
                    }
                    if (iFlag.val != 0) {
                        EquationSolveJenkinTraub.RealIT(iFlag, NZ, s, N, p, NN, qp, szr, szi, K, qk);
                        if (NZ.val > 0) {
                            return;
                        }
                        stry = 1;
                        betas *= 0.25;
                        if (iFlag.val != 0) {
                            ui.val = -(s.val + s.val);
                            vi.val = s.val * s.val;
                            continue;
                        }
                    }
                    for (i = 0; i < N; ++i) {
                        K[i] = svk[i];
                    }
                    if (!vpass || vtry == 1) break;
                }
                EquationSolveJenkinTraub.QuadSD(NN, u, v, p, qp, a, b);
                tFlag = EquationSolveJenkinTraub.calcSC(N, a.val, b.val, a1, a3, a7, c, d, e, f, g, h, K, u, v, qk);
            }
            ovv = vv;
            oss = ss;
            otv = tv;
            ots = ts;
        }
    }

    private static void QuadSD(int NN, double u, double v, double[] p, double[] q, DoubleNum a, DoubleNum b) {
        if (p.length != q.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        q[0] = b.val = p[0];
        q[1] = a.val = -(b.val * u) + p[1];
        for (int i = 2; i < NN; ++i) {
            q[i] = -(a.val * u + b.val * v) + p[i];
            b.val = a.val;
            a.val = q[i];
        }
    }

    private static int calcSC(int N, double a, double b, DoubleNum a1, DoubleNum a3, DoubleNum a7, DoubleNum c, DoubleNum d, DoubleNum e, DoubleNum f, DoubleNum g, DoubleNum h, double[] K, double u, double v, double[] qk) {
        if (K.length != qk.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        int dumFlag = 3;
        EquationSolveJenkinTraub.QuadSD(N, u, v, K, qk, c, d);
        if (Math.abs(c.val) <= 2.220446049250313E-14 * Math.abs(K[N - 1]) && Math.abs(d.val) <= 2.220446049250313E-14 * Math.abs(K[N - 2])) {
            return dumFlag;
        }
        h.val = v * b;
        if (Math.abs(d.val) >= Math.abs(c.val)) {
            dumFlag = 2;
            e.val = a / d.val;
            f.val = c.val / d.val;
            g.val = u * b;
            a3.val = e.val * (g.val + a) + h.val * (b / d.val);
            a1.val = -a + f.val * b;
            a7.val = h.val + (f.val + u) * a;
        } else {
            dumFlag = 1;
            e.val = a / c.val;
            f.val = d.val / c.val;
            g.val = e.val * u;
            a3.val = e.val * a + (g.val + h.val / c.val) * b;
            a1.val = -(a * (d.val / c.val)) + b;
            a7.val = g.val * d.val + h.val * f.val + a;
        }
        return dumFlag;
    }

    private static void nextK(int N, int tFlag, double a, double b, double a1, DoubleNum a3, DoubleNum a7, double[] K, double[] qk, double[] qp) {
        double temp;
        if (K.length != qk.length || qk.length != qp.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        if (tFlag == 3) {
            K[0] = 0.0;
            K[1] = 0.0;
            for (int i = 2; i < N; ++i) {
                K[i] = qk[i - 2];
            }
            return;
        }
        double d = temp = tFlag == 1 ? b : a;
        if (Math.abs(a1) > 2.220446049250313E-15 * Math.abs(temp)) {
            a7.val /= a1;
            a3.val /= a1;
            K[0] = qp[0];
            K[1] = -(a7.val * qp[0]) + qp[1];
            for (int i = 2; i < N; ++i) {
                K[i] = -(a7.val * qp[i - 1]) + a3.val * qk[i - 2] + qp[i];
            }
        } else {
            K[0] = 0.0;
            K[1] = -a7.val * qp[0];
            for (int i = 2; i < N; ++i) {
                K[i] = -(a7.val * qp[i - 1]) + a3.val * qk[i - 2];
            }
        }
    }

    private static void newest(int tFlag, DoubleNum uu, DoubleNum vv, double a, double a1, double a3, double a7, double b, double c, double d, double f, double g, double h, double u, double v, double[] K, int N, double[] p) {
        if (K.length != p.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        uu.val = 0.0;
        vv.val = 0.0;
        if (tFlag != 3) {
            double a5;
            double a4;
            if (tFlag != 2) {
                a4 = a + u * b + h * f;
                a5 = c + (u + v * f) * d;
            } else {
                a4 = (a + g) * f + h;
                a5 = (f + u) * c + v * d;
            }
            double b1 = -K[N - 1] / p[N];
            double b2 = -(K[N - 2] + b1 * p[N - 1]) / p[N];
            double c1 = v * b2 * a1;
            double c2 = b1 * a7;
            double c3 = b1 * b1 * a3;
            double c4 = -(c2 + c3) + c1;
            double temp = -c4 + a5 + b1 * a4;
            if (temp != 0.0) {
                uu.val = -((u * (c3 + c2) + v * (b1 * a1 + b2 * a7)) / temp) + u;
                vv.val = v * (1.0 + c4 / temp);
            }
        }
    }

    private static void QuadIT(int N, IntNum NZ, double uu, double vv, DoubleNum szr, DoubleNum szi, DoubleNum lzr, DoubleNum lzi, double[] qp, int NN, DoubleNum a, DoubleNum b, double[] p, double[] qk, DoubleNum a1, DoubleNum a3, DoubleNum a7, DoubleNum c, DoubleNum d, DoubleNum e, DoubleNum f, DoubleNum g, DoubleNum h, double[] K) {
        if (K.length != qk.length || qk.length != p.length || p.length != qp.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        int j = 0;
        boolean triedFlag = false;
        double omp = 0.0;
        double relstp = 0.0;
        DoubleNum ui = new DoubleNum();
        DoubleNum vi = new DoubleNum();
        NZ.val = 0;
        double u = uu;
        double v = vv;
        do {
            int tFlag;
            int i;
            EquationSolveJenkinTraub.Quad(1.0, u, v, szr, szi, lzr, lzi);
            if (Math.abs(Math.abs(szr.val) - Math.abs(lzr.val)) > 0.01 * Math.abs(lzr.val)) break;
            EquationSolveJenkinTraub.QuadSD(NN, u, v, p, qp, a, b);
            double mp = Math.abs(-(szr.val * b.val) + a.val) + Math.abs(szi.val * b.val);
            double zm = Math.sqrt(Math.abs(v));
            double ee = 2.0 * Math.abs(qp[0]);
            double t = -(szr.val * b.val);
            for (i = 1; i < N; ++i) {
                ee = ee * zm + Math.abs(qp[i]);
            }
            ee = ee * zm + Math.abs(a.val + t);
            if (mp <= 20.0 * (ee = (9.0 * ee + 2.0 * Math.abs(t) - 7.0 * (Math.abs(a.val + t) + zm * Math.abs(b.val))) * 2.220446049250313E-16)) {
                NZ.val = 2;
                break;
            }
            if (++j > 20) break;
            if (j >= 2 && relstp <= 0.01 && mp >= omp && !triedFlag) {
                relstp = relstp < 2.220446049250313E-16 ? SQRT_DBL_EPSILON : Math.sqrt(relstp);
                u -= u * relstp;
                v += v * relstp;
                EquationSolveJenkinTraub.QuadSD(NN, u, v, p, qp, a, b);
                for (i = 0; i < 5; ++i) {
                    tFlag = EquationSolveJenkinTraub.calcSC(N, a.val, b.val, a1, a3, a7, c, d, e, f, g, h, K, u, v, qk);
                    EquationSolveJenkinTraub.nextK(N, tFlag, a.val, b.val, a1.val, a3, a7, K, qk, qp);
                }
                triedFlag = true;
                j = 0;
            }
            omp = mp;
            tFlag = EquationSolveJenkinTraub.calcSC(N, a.val, b.val, a1, a3, a7, c, d, e, f, g, h, K, u, v, qk);
            EquationSolveJenkinTraub.nextK(N, tFlag, a.val, b.val, a1.val, a3, a7, K, qk, qp);
            tFlag = EquationSolveJenkinTraub.calcSC(N, a.val, b.val, a1, a3, a7, c, d, e, f, g, h, K, u, v, qk);
            EquationSolveJenkinTraub.newest(tFlag, ui, vi, a.val, a1.val, a3.val, a7.val, b.val, c.val, d.val, f.val, g.val, h.val, u, v, K, N, p);
            if (vi.val == 0.0) continue;
            relstp = Math.abs((-v + vi.val) / vi.val);
            u = ui.val;
            v = vi.val;
        } while (vi.val != 0.0);
    }

    private static void RealIT(IntNum iFlag, IntNum NZ, DoubleNum sss, int N, double[] p, int NN, double[] qp, DoubleNum szr, DoubleNum szi, double[] K, double[] qk) {
        if (p.length != qp.length || qp.length != K.length || K.length != qk.length) {
            throw new IllegalArgumentException("Wrong argument");
        }
        int j = 0;
        int nm1 = N - 1;
        double omp = 0.0;
        double t = 0.0;
        NZ.val = 0;
        iFlag.val = 0;
        double s = sss.val;
        while (true) {
            double kv;
            int i;
            double pv;
            qp[0] = pv = p[0];
            for (i = 1; i < NN; ++i) {
                qp[i] = pv = pv * s + p[i];
            }
            double mp = Math.abs(pv);
            double ms = Math.abs(s);
            double ee = 0.5 * Math.abs(qp[0]);
            for (i = 1; i < NN; ++i) {
                ee = ee * ms + Math.abs(qp[i]);
            }
            if (mp <= 4.440892098500626E-15 * (2.0 * ee - mp)) {
                NZ.val = 1;
                szr.val = s;
                szi.val = 0.0;
                break;
            }
            if (++j > 10) break;
            if (j >= 2 && Math.abs(t) <= 0.001 * Math.abs(-t + s) && mp > omp) {
                iFlag.val = 1;
                sss.val = s;
                break;
            }
            omp = mp;
            qk[0] = kv = K[0];
            for (i = 1; i < N; ++i) {
                qk[i] = kv = kv * s + K[i];
            }
            if (Math.abs(kv) > Math.abs(K[nm1]) * 10.0 * 2.220446049250313E-16) {
                t = -(pv / kv);
                K[0] = qp[0];
                for (i = 1; i < N; ++i) {
                    K[i] = t * qk[i - 1] + qp[i];
                }
            } else {
                K[0] = 0.0;
                for (i = 1; i < N; ++i) {
                    K[i] = qk[i - 1];
                }
            }
            kv = K[0];
            for (i = 1; i < N; ++i) {
                kv = kv * s + K[i];
            }
            t = Math.abs(kv) > Math.abs(K[nm1]) * 10.0 * 2.220446049250313E-16 ? -(pv / kv) : 0.0;
            s += t;
        }
    }

    private static void Quad(double a, double b1, double c, DoubleNum sr, DoubleNum si, DoubleNum lr, DoubleNum li) {
        double d;
        double e;
        li.val = 0.0;
        lr.val = 0.0;
        si.val = 0.0;
        sr.val = 0.0;
        if (a == 0.0) {
            sr.val = b1 != 0.0 ? -(c / b1) : sr.val;
            return;
        }
        if (c == 0.0) {
            lr.val = -(b1 / a);
            return;
        }
        double b = 0.5 * b1;
        if (Math.abs(b) < Math.abs(c)) {
            e = c >= 0.0 ? a : -a;
            e = -e + b * (b / Math.abs(c));
            d = Math.sqrt(Math.abs(e)) * Math.sqrt(Math.abs(c));
        } else {
            e = -(a / b * (c / b)) + 1.0;
            d = Math.sqrt(Math.abs(e)) * Math.abs(b);
        }
        if (e >= 0.0) {
            d = b >= 0.0 ? -d : d;
            lr.val = (-b + d) / a;
            sr.val = lr.val != 0.0 ? c / lr.val / a : sr.val;
        } else {
            lr.val = sr.val = -(b / a);
            si.val = Math.abs(d / a);
            li.val = -si.val;
        }
    }

    static class DoubleNum {
        public double val;

        DoubleNum() {
        }
    }

    private static class IntNum {
        public int val;

        private IntNum() {
        }
    }
}

