/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.helper.AdamsBashforthMoulton;

public class DiffEquationTimeDistance
extends AdamsBashforthMoulton {
    private double o_r;
    private double o_m;
    private double o_dm;
    private double o_cs;
    private double o_dw;
    private double o_cc;
    private double o_sum;
    private double y_max;
    private double t0;
    private double y0;
    private int state = 1;
    private boolean maxExists;

    public void setMaxEsists(boolean value) {
        this.maxExists = value;
    }

    public void setInitial(double t0, double y0) {
        this.t0 = t0;
        this.y0 = y0;
    }

    public void setParameters(double omega_radiation, double omega_matter, double omega_dark_matter, double omega_cosmic_string, double omega_cosmic_dw, double omega_cosmological_constant, double y_max) {
        this.o_r = omega_radiation;
        this.o_m = omega_matter;
        this.o_dm = omega_dark_matter;
        this.o_cs = omega_cosmic_string;
        this.o_dw = omega_cosmic_dw;
        this.o_cc = omega_cosmological_constant;
        this.o_sum = this.o_r + this.o_m + this.o_dm + this.o_cs + this.o_dw + this.o_cc;
        this.y_max = y_max;
    }

    public double function(double y, double t) {
        double EPS = 1.0E-8;
        double temp = this.o_r / (y * y) + (this.o_m + this.o_dm) / y + this.o_cs + this.o_dw * y + this.o_cc * (y * y) + (1.0 - this.o_sum);
        if (this.state == 1) {
            if (this.maxExists && this.y_max - y < 1.0E-8) {
                this.state = 2;
            }
            return Math.sqrt(Math.abs(temp));
        }
        if (this.state == 2) {
            return -Math.sqrt(Math.abs(temp));
        }
        return Double.NaN;
    }

    public double initialValue(double t0) {
        if (Math.abs(this.t0 - t0) < 1.0E-8) {
            System.out.println("initial value-> t0: " + t0 + "; y0: " + this.y0);
            return this.y0;
        }
        throw new IllegalArgumentException("Wrong initial state");
    }
}

