/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

abstract class BasicGaussian {
    private final double[] coefficients3points = new double[]{0.5555555555555556, 0.8888888888888888, 0.5555555555555556};
    private final double[] values3points = new double[]{0.7745966692414834, 0.0, -0.7745966692414834};
    private final double[] coefficients5points = new double[]{0.23692688505618908, 0.47862867049936647, 0.5688888888888889, 0.47862867049936647, 0.23692688505618908};
    private final double[] values5points = new double[]{0.906179845938664, 0.5384693101056831, 0.0, -0.5384693101056831, -0.906179845938664};
    private final double[] coefficients15points = new double[]{0.03075324199611727, 0.07036604748810812, 0.10715922046717194, 0.13957067792615432, 0.16626920581699392, 0.1861610000155622, 0.19843148532711158, 0.2025782419255613, 0.19843148532711158, 0.1861610000155622, 0.16626920581699392, 0.13957067792615432, 0.10715922046717194, 0.07036604748810812, 0.03075324199611727};
    private final double[] values15points = new double[]{0.9879925180204854, 0.937273392400706, 0.8482065834104272, 0.7244177313601701, 0.5709721726085388, 0.3941513470775634, 0.20119409399743451, 0.0, -0.20119409399743451, -0.3941513470775634, -0.5709721726085388, -0.7244177313601701, -0.8482065834104272, -0.937273392400706, -0.9879925180204854};
    private final double[] coefficients45points = new double[]{0.003582663155283559, 0.00832318929621824, 0.013031104991582785, 0.01767753525793759, 0.022239847550578732, 0.026696213967577664, 0.031025374934515466, 0.03520669220160902, 0.03922023672930245, 0.04304688070916497, 0.046668387718373366, 0.05006749923795203, 0.05322801673126895, 0.056134878759786476, 0.05877423271884174, 0.06113350083106652, 0.06320144007381993, 0.06496819575072343, 0.06642534844984253, 0.06756595416360754, 0.06838457737866968, 0.06887731697766132, 0.06904182482923202, 0.06887731697766132, 0.06838457737866968, 0.06756595416360754, 0.06642534844984253, 0.06496819575072343, 0.06320144007381993, 0.06113350083106652, 0.05877423271884174, 0.056134878759786476, 0.05322801673126895, 0.05006749923795203, 0.046668387718373366, 0.04304688070916497, 0.03922023672930245, 0.03520669220160902, 0.031025374934515466, 0.026696213967577664, 0.022239847550578732, 0.01767753525793759, 0.013031104991582785, 0.00832318929621824, 0.003582663155283559};
    private final double[] values45points = new double[]{0.9986036451819367, 0.9926499984472037, 0.9819687150345405, 0.9666083103968947, 0.9466416909956291, 0.9221639367190004, 0.8932916717532418, 0.8601624759606642, 0.8229342205020863, 0.7817843125939062, 0.7369088489454904, 0.6885216807712006, 0.6368533944532233, 0.5821502125693532, 0.5246728204629161, 0.4646951239196351, 0.4025029438585419, 0.33839265425060217, 0.27266976975237756, 0.20564748978326375, 0.13764520598325303, 0.06898698016314417, 0.0, -0.06898698016314417, -0.13764520598325303, -0.20564748978326375, -0.27266976975237756, -0.33839265425060217, -0.4025029438585419, -0.4646951239196351, -0.5246728204629161, -0.5821502125693532, -0.6368533944532233, -0.6885216807712006, -0.7369088489454904, -0.7817843125939062, -0.8229342205020863, -0.8601624759606642, -0.8932916717532418, -0.9221639367190004, -0.9466416909956291, -0.9666083103968947, -0.9819687150345405, -0.9926499984472037, -0.9986036451819367};

    BasicGaussian() {
    }

    abstract double func(double var1);

    private final double basicNpointsGaussianQuadrature(double[] coefficients, double[] values, int num) {
        double sum = 0.0;
        for (int i = 0; i < num; ++i) {
            sum += coefficients[i] * this.func(values[i]);
        }
        return sum;
    }

    double basicGaussianQuadrature(int choice) {
        switch (choice) {
            case 1: {
                return this.basicNpointsGaussianQuadrature(this.coefficients45points, this.values45points, 45);
            }
            case 2: {
                return this.basicNpointsGaussianQuadrature(this.coefficients15points, this.values15points, 15);
            }
            case 3: {
                return this.basicNpointsGaussianQuadrature(this.coefficients5points, this.values5points, 5);
            }
        }
        throw new IllegalArgumentException("Wrong argument");
    }
}

