/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model.helper;

import edu.calstatela.scivi.model.helper.NumericalDifferentialEquation;

abstract class AdamsBashforthMoulton
extends NumericalDifferentialEquation {
    AdamsBashforthMoulton() {
    }

    public void solve(double lower, double upper, int subdivisions, double[] resultT, double[] resultY, double[] resultDyDt) {
        this.solve5_4(lower, upper, subdivisions, resultT, resultY, resultDyDt);
    }

    private void solve5_4(double lower, double upper, int subdivisions, double[] resultT, double[] resultY, double[] resultDyDt) {
        int i;
        double stepSize = (upper - lower) / (double)subdivisions;
        double t = lower;
        double y = this.initialValue(t);
        int count = 0;
        resultT[count] = t;
        resultY[count] = y;
        ++count;
        for (i = 0; i < 5; ++i) {
            double k1 = this.function(y, t);
            double k2 = this.function(y + 0.5 * stepSize * k1, t + 0.5 * stepSize);
            double k3 = this.function(y + 0.5 * stepSize * k2, t + 0.5 * stepSize);
            double k4 = this.function(y + stepSize * k3, t + stepSize);
            resultDyDt[count - 1] = k1;
            resultT[count] = t += stepSize;
            resultY[count] = y += stepSize / 6.0 * (k1 + 2.0 * k2 + 2.0 * k3 + k4);
            ++count;
        }
        double funcPrev1 = this.function(resultY[count - 1], resultT[count - 1]);
        double funcPrev2 = this.function(resultY[count - 2], resultT[count - 2]);
        double funcPrev3 = this.function(resultY[count - 3], resultT[count - 3]);
        double funcPrev4 = this.function(resultY[count - 4], resultT[count - 4]);
        double funcPrev5 = this.function(resultY[count - 5], resultT[count - 5]);
        double yPrev = resultY[count - 1];
        for (i = 5; i < subdivisions; ++i) {
            resultDyDt[count - 1] = funcPrev1;
            y = yPrev + stepSize / 720.0 * (1901.0 * funcPrev1 - 2774.0 * funcPrev2 + 2616.0 * funcPrev3 - 1274.0 * funcPrev4 + 251.0 * funcPrev5);
            double funcCurr = this.function(y, t += stepSize);
            y = yPrev + stepSize / 720.0 * (251.0 * funcCurr + 646.0 * funcPrev1 - 264.0 * funcPrev2 + 106.0 * funcPrev3 - 19.0 * funcPrev4);
            resultT[count] = t;
            resultY[count] = y;
            ++count;
            funcPrev5 = funcPrev4;
            funcPrev4 = funcPrev3;
            funcPrev3 = funcPrev2;
            funcPrev2 = funcPrev1;
            funcPrev1 = funcCurr;
            yPrev = y;
        }
        resultDyDt[count - 1] = funcPrev1;
    }

    private void solve8_7(double lower, double upper, int subdivisions, double[] resultT, double[] resultY, double[] resultDyDt) {
        int i;
        double stepSize = (upper - lower) / (double)subdivisions;
        double t = lower;
        double y = this.initialValue(t);
        int count = 0;
        resultT[count] = t;
        resultY[count] = y;
        ++count;
        for (i = 0; i < 8; ++i) {
            double k1 = this.function(y, t);
            double k2 = this.function(y + 0.5 * stepSize * k1, t + 0.5 * stepSize);
            double k3 = this.function(y + 0.5 * stepSize * k2, t + 0.5 * stepSize);
            double k4 = this.function(y + stepSize * k3, t + stepSize);
            resultDyDt[count - 1] = k1;
            resultT[count] = t += stepSize;
            resultY[count] = y += stepSize / 6.0 * (k1 + 2.0 * k2 + 2.0 * k3 + k4);
            ++count;
        }
        double funcPrev1 = this.function(resultY[count - 1], resultT[count - 1]);
        double funcPrev2 = this.function(resultY[count - 2], resultT[count - 2]);
        double funcPrev3 = this.function(resultY[count - 3], resultT[count - 3]);
        double funcPrev4 = this.function(resultY[count - 4], resultT[count - 4]);
        double funcPrev5 = this.function(resultY[count - 5], resultT[count - 5]);
        double funcPrev6 = this.function(resultY[count - 6], resultT[count - 6]);
        double funcPrev7 = this.function(resultY[count - 7], resultT[count - 7]);
        double funcPrev8 = this.function(resultY[count - 8], resultT[count - 8]);
        double yPrev = resultY[count - 1];
        for (i = 8; i < subdivisions; ++i) {
            resultDyDt[count - 1] = funcPrev1;
            y = yPrev + stepSize / 120960.0 * (434241.0 * funcPrev1 - 1152169.0 * funcPrev2 + 2183877.0 * funcPrev3 - 2664477.0 * funcPrev4 + 2102243.0 * funcPrev5 - 1041723.0 * funcPrev6 + 295767.0 * funcPrev7 - 36799.0 * funcPrev8);
            double funcCurr = this.function(y, t += stepSize);
            y = yPrev + stepSize / 120960.0 * (36799.0 * funcCurr + 139849.0 * funcPrev1 - 121797.0 * funcPrev2 + 123133.0 * funcPrev3 - 88547.0 * funcPrev4 + 41499.0 * funcPrev5 - 11351.0 * funcPrev6 + 1375.0 * funcPrev7);
            resultT[count] = t;
            resultY[count] = y;
            ++count;
            funcPrev8 = funcPrev7;
            funcPrev7 = funcPrev6;
            funcPrev6 = funcPrev5;
            funcPrev5 = funcPrev4;
            funcPrev4 = funcPrev3;
            funcPrev3 = funcPrev2;
            funcPrev2 = funcPrev1;
            funcPrev1 = funcCurr;
            yPrev = y;
        }
        resultDyDt[count - 1] = funcPrev1;
    }

    private void solve12_11(double lower, double upper, int subdivisions, double[] resultT, double[] resultY, double[] resultDyDt) {
        int i;
        double stepSize = (upper - lower) / (double)subdivisions;
        double t = lower;
        double y = this.initialValue(t);
        int count = 0;
        resultT[count] = t;
        resultY[count] = y;
        ++count;
        for (i = 0; i < 12; ++i) {
            double k1 = this.function(y, t);
            double k2 = this.function(y + 0.5 * stepSize * k1, t + 0.5 * stepSize);
            double k3 = this.function(y + 0.5 * stepSize * k2, t + 0.5 * stepSize);
            double k4 = this.function(y + stepSize * k3, t + stepSize);
            resultDyDt[count - 1] = k1;
            resultT[count] = t += stepSize;
            resultY[count] = y += stepSize / 6.0 * (k1 + 2.0 * k2 + 2.0 * k3 + k4);
            ++count;
        }
        double funcPrev1 = this.function(resultY[count - 1], resultT[count - 1]);
        double funcPrev2 = this.function(resultY[count - 2], resultT[count - 2]);
        double funcPrev3 = this.function(resultY[count - 3], resultT[count - 3]);
        double funcPrev4 = this.function(resultY[count - 4], resultT[count - 4]);
        double funcPrev5 = this.function(resultY[count - 5], resultT[count - 5]);
        double funcPrev6 = this.function(resultY[count - 6], resultT[count - 6]);
        double funcPrev7 = this.function(resultY[count - 7], resultT[count - 7]);
        double funcPrev8 = this.function(resultY[count - 8], resultT[count - 8]);
        double funcPrev9 = this.function(resultY[count - 9], resultT[count - 9]);
        double funcPrev10 = this.function(resultY[count - 10], resultT[count - 10]);
        double funcPrev11 = this.function(resultY[count - 11], resultT[count - 11]);
        double funcPrev12 = this.function(resultY[count - 12], resultT[count - 12]);
        double yPrev = resultY[count - 1];
        for (i = 12; i < subdivisions; ++i) {
            resultDyDt[count - 1] = funcPrev1;
            y = yPrev + stepSize / 9.580032E8 * (4.527766399E9 * funcPrev1 - 1.9433810163E10 * funcPrev2 + 6.1633227185E10 * funcPrev3 - 1.35579356757E11 * funcPrev4 + 2.14139355366E11 * funcPrev5 - 2.47741639374E11 * funcPrev6 + 2.11103573298E11 * funcPrev7 - 1.3136586729E11 * funcPrev8 + 5.8189107627E10 * funcPrev9 - 1.7410248271E10 * funcPrev10 + 3.158642445E9 * funcPrev11 - 2.62747265E8 * funcPrev12);
            double funcCurr = this.function(y, t += stepSize);
            y = yPrev + stepSize / 9.580032E8 * (2.62747265E8 * funcCurr + 1.374799219E9 * funcPrev1 - 2.092490673E9 * funcPrev2 + 3.828828885E9 * funcPrev3 - 5.519460582E9 * funcPrev4 + 6.043521486E9 * funcPrev5 - 4.963166514E9 * funcPrev6 + 3.007739418E9 * funcPrev7 - 1.305971115E9 * funcPrev8 + 3.84709327E8 * funcPrev9 - 6.8928781E7 * funcPrev10 + 5675265.0 * funcPrev11);
            resultT[count] = t;
            resultY[count] = y;
            ++count;
            funcPrev12 = funcPrev11;
            funcPrev11 = funcPrev10;
            funcPrev10 = funcPrev9;
            funcPrev9 = funcPrev8;
            funcPrev8 = funcPrev7;
            funcPrev7 = funcPrev6;
            funcPrev6 = funcPrev5;
            funcPrev5 = funcPrev4;
            funcPrev4 = funcPrev3;
            funcPrev3 = funcPrev2;
            funcPrev2 = funcPrev1;
            funcPrev1 = funcCurr;
            yPrev = y;
        }
        resultDyDt[count - 1] = funcPrev1;
    }
}

