/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model;

import edu.calstatela.scivi.model.helper.DiffEquationTimeDistance;
import edu.calstatela.scivi.model.helper.EquationSolveJenkinTraub;
import edu.calstatela.scivi.model.helper.FuncIntegrateTimeDistance;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TimeDistance {
    protected TimeDistance() {
    }

    private static int countRoot(double rootr, double rooti, double[] zeror, double[] zeroi) {
        double EPS = 1.0E-10;
        int count = 0;
        int size = zeror.length;
        for (int i = 0; i < size; ++i) {
            if (!(Math.abs(zeror[i] - rootr) < 1.0E-10) || !(Math.abs(zeroi[i] - rooti) < 1.0E-10)) continue;
            ++count;
        }
        return count;
    }

    private static double findClosestSingleOrTripleRoot(int dir, double num, double[] zeror, double[] zeroi) {
        double EPS = 1.0E-10;
        double res = Double.NaN;
        if (dir == 1) {
            int size = zeror.length;
            for (int i = 0; i < size; ++i) {
                int temp;
                if (!(Math.abs(zeroi[i]) < 1.0E-10) || !(zeror[i] >= 0.0) || !(zeror[i] < num) || (temp = TimeDistance.countRoot(zeror[i], 0.0, zeror, zeroi)) != 1 && temp != 3) continue;
                if (Double.isNaN(res)) {
                    res = zeror[i];
                    continue;
                }
                if (!(zeror[i] > res)) continue;
                res = zeror[i];
            }
        } else if (dir == 2) {
            int size = zeror.length;
            for (int i = 0; i < size; ++i) {
                int temp;
                if (!(Math.abs(zeroi[i]) < 1.0E-10) || !(zeror[i] >= 0.0) || !(zeror[i] > num) || (temp = TimeDistance.countRoot(zeror[i], 0.0, zeror, zeroi)) != 1 && temp != 3) continue;
                if (Double.isNaN(res)) {
                    res = zeror[i];
                    continue;
                }
                if (!(zeror[i] < res)) continue;
                res = zeror[i];
            }
        } else {
            throw new IllegalArgumentException("Wrong direction");
        }
        return res;
    }

    public static JFreeChart generateChart(double radiation, double matter, double constant, double domainWall, double cosString, double darkMatter) {
        int[] counter = new int[1];
        double[][] results = TimeDistance.generateData(radiation, matter, constant, domainWall, cosString, darkMatter, counter);
        XYSeries series = new XYSeries((Comparable)((Object)"Time and Relative Distance"));
        if (results != null) {
            for (int i = 0; i < counter[0]; ++i) {
                series.add(results[i][0], results[i][1]);
            }
        }
        XYSeriesCollection xyDataset = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart("", "", "", xyDataset, PlotOrientation.VERTICAL, false, false, false);
        return chart;
    }

    public static double[][] generateData(double radiation, double matter, double constant, double domainWall, double cosString, double darkMatter, int[] counterStore) {
        double omega_sum = radiation + matter + constant + domainWall + cosString + darkMatter;
        FuncIntegrateTimeDistance func = new FuncIntegrateTimeDistance();
        DiffEquationTimeDistance diff = new DiffEquationTimeDistance();
        double EPS = 1.0E-10;
        double tempDeriv = Double.NaN;
        double leftRoot = -10.0;
        double rightRoot = -10.0;
        double yInit = -10.0;
        double yMax = -10.0;
        int subdivisions = 2000;
        boolean maxExists = false;
        func.setParameters(radiation, matter, darkMatter, cosString, domainWall, constant);
        double[] coeff = new double[5];
        coeff[4] = constant;
        coeff[3] = domainWall;
        coeff[2] = 1.0 - omega_sum + cosString;
        coeff[1] = matter + darkMatter;
        coeff[0] = radiation;
        double temp = coeff[4] + coeff[3] + coeff[2] + coeff[1] + coeff[0];
        if (temp >= 0.0) {
            double xInit;
            int i;
            double[][] res = EquationSolveJenkinTraub.polySolve(coeff);
            double[] zeror = res[0];
            double[] zeroi = res[1];
            for (i = 0; i < zeror.length; ++i) {
                System.out.println("zero: " + zeror[i] + " + " + zeroi[i] + " i");
            }
            double rootCount = TimeDistance.countRoot(1.0, 0.0, zeror, zeroi);
            if (Math.abs(temp) < 1.0E-10 && (rootCount == 1.0 || rootCount == 3.0)) {
                if (rootCount == 1.0) {
                    tempDeriv = 4.0 * coeff[4] + 3.0 * coeff[3] + 2.0 * coeff[2] + coeff[1];
                } else if (rootCount == 3.0) {
                    tempDeriv = 24.0 * coeff[4] + 6.0 * coeff[3];
                }
                if (tempDeriv < 0.0) {
                    leftRoot = TimeDistance.findClosestSingleOrTripleRoot(1, 1.0, zeror, zeroi);
                    rightRoot = 1.0;
                } else if (tempDeriv > 0.0) {
                    leftRoot = 1.0;
                    rightRoot = TimeDistance.findClosestSingleOrTripleRoot(2, 1.0, zeror, zeroi);
                }
            } else {
                leftRoot = TimeDistance.findClosestSingleOrTripleRoot(1, 1.0, zeror, zeroi);
                rightRoot = TimeDistance.findClosestSingleOrTripleRoot(2, 1.0, zeror, zeroi);
            }
            if (Double.isNaN(leftRoot)) {
                yMax = Double.POSITIVE_INFINITY;
                maxExists = false;
            } else {
                yMax = leftRoot == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / leftRoot;
                maxExists = true;
            }
            if (Double.isNaN(rightRoot)) {
                xInit = 0.0;
                yInit = 0.0;
            } else {
                xInit = 0.0;
                yInit = 1.0 / rightRoot;
            }
            System.out.println("leftRoot: " + leftRoot + "; rightRoot: " + rightRoot);
            System.out.println("yInit: " + yInit + "; yMax: " + yMax + "; max: " + maxExists);
            double constValue = func.integrate(yInit, 1.0, 5, 1);
            diff.setParameters(radiation, matter, darkMatter, cosString, domainWall, constant, yMax);
            diff.setMaxEsists(maxExists);
            double y = yInit + 0.01;
            double x = func.integrate(yInit, y, 2, 1);
            diff.setInitial(x, y);
            double[] resultT = new double[2001];
            double[] resultY = new double[2001];
            double[] resultDyDt = new double[2001];
            diff.solve(x, 4.0, 2000, resultT, resultY, resultDyDt);
            int counter2 = 2000;
            for (i = 0; i < 2000; ++i) {
                if (!(resultY[i] < 0.0)) continue;
                --counter2;
            }
            int size = 2000 / counter2 + (2000 % counter2 == 0 ? 0 : 1);
            int counter = 0;
            double[][] results = new double[size * counter2 + 2][2];
            for (i = 0; i < counter2; ++i) {
                if (i < counter2 - 1) {
                    for (int j = 0; j < size; ++j) {
                        results[counter][0] = TimeDistance.linearInterpolation((double)j / (double)size, resultT[i], resultT[i + 1]);
                        results[counter][1] = TimeDistance.cubicHermiteInterpolation(results[counter][0], resultT[i], resultT[i + 1], resultY[i], resultY[i + 1], resultDyDt[i], resultDyDt[i + 1]);
                        double[] dArray = results[counter];
                        dArray[0] = dArray[0] / constValue;
                        if (counter % 47 == 0) {
                            System.out.println("T_curr: " + resultT[i] + "; T_next: " + resultT[i + 1] + "; Y_curr: " + resultY[i] + "; Y_next: " + resultY[i + 1] + "; deriv: " + resultDyDt[i] + "; deriv_next: " + resultDyDt[i + 1] + "; T: " + results[counter][0] * constValue + "; Y: " + results[counter][1]);
                        }
                        ++counter;
                    }
                    continue;
                }
                results[counter][0] = resultT[i] / constValue;
                results[counter][1] = resultY[i];
                ++counter;
            }
            for (i = counter; i > 0; --i) {
                if (!(results[i - 1][0] >= 0.0) || !(results[i - 1][1] >= 0.0)) continue;
                counter = i;
                break;
            }
            counterStore[0] = counter;
            return results;
        }
        System.out.println("Unphysical values");
        return null;
    }

    private static double linearInterpolation(double t, double curr, double next) {
        return curr + t * (next - curr);
    }

    private static double cubicHermiteInterpolation(double x, double xCurr, double xNext, double yCurr, double yNext, double derivCurr, double derivNext) {
        double h = xNext - xCurr;
        double t = (x - xCurr) / h;
        double t2 = t * t;
        double t3 = t2 * t;
        double h00 = 2.0 * t3 - 3.0 * t2 + 1.0;
        double h10 = t3 - 2.0 * t2 + t;
        double h01 = -2.0 * t3 + 3.0 * t2;
        double h11 = t3 - t2;
        return h00 * yCurr + h10 * h * derivCurr + h01 * yNext + h11 * h * derivNext;
    }

    public static double getUniverseAge(double radiation, double matter, double constant, double domainWall, double cosString, double darkMatter) {
        double omega_sum = radiation + matter + constant + domainWall + cosString + darkMatter;
        double EPS = 1.0E-10;
        double tempDeriv = Double.NaN;
        double leftRoot = -10.0;
        double rightRoot = -10.0;
        double yInit = -10.0;
        double yMax = -10.0;
        boolean maxExists = false;
        FuncIntegrateTimeDistance func = new FuncIntegrateTimeDistance();
        func.setParameters(radiation, matter, darkMatter, cosString, domainWall, constant);
        double[] coeff = new double[5];
        coeff[4] = constant;
        coeff[3] = domainWall;
        coeff[2] = 1.0 - omega_sum + cosString;
        coeff[1] = matter + darkMatter;
        coeff[0] = radiation;
        double temp = coeff[4] + coeff[3] + coeff[2] + coeff[1] + coeff[0];
        if (temp >= 0.0) {
            double[][] res = EquationSolveJenkinTraub.polySolve(coeff);
            double[] zeror = res[0];
            double[] zeroi = res[1];
            for (int i = 0; i < zeror.length; ++i) {
                System.out.println("zero: " + zeror[i] + " + " + zeroi[i] + " i");
            }
            double rootCount = TimeDistance.countRoot(1.0, 0.0, zeror, zeroi);
            if (Math.abs(temp) < 1.0E-10 && (rootCount == 1.0 || rootCount == 3.0)) {
                if (rootCount == 1.0) {
                    tempDeriv = 4.0 * coeff[4] + 3.0 * coeff[3] + 2.0 * coeff[2] + coeff[1];
                } else if (rootCount == 3.0) {
                    tempDeriv = 24.0 * coeff[4] + 6.0 * coeff[3];
                }
                if (tempDeriv < 0.0) {
                    leftRoot = TimeDistance.findClosestSingleOrTripleRoot(1, 1.0, zeror, zeroi);
                    rightRoot = 1.0;
                } else if (tempDeriv > 0.0) {
                    leftRoot = 1.0;
                    rightRoot = TimeDistance.findClosestSingleOrTripleRoot(2, 1.0, zeror, zeroi);
                }
            } else {
                leftRoot = TimeDistance.findClosestSingleOrTripleRoot(1, 1.0, zeror, zeroi);
                rightRoot = TimeDistance.findClosestSingleOrTripleRoot(2, 1.0, zeror, zeroi);
            }
            if (Double.isNaN(leftRoot)) {
                yMax = Double.POSITIVE_INFINITY;
                maxExists = false;
            } else {
                yMax = leftRoot == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / leftRoot;
                maxExists = true;
            }
            if (Double.isNaN(rightRoot)) {
                double xInit = 0.0;
                yInit = 0.0;
            } else {
                double xInit = 0.0;
                yInit = 1.0 / rightRoot;
            }
            System.out.println("leftRoot: " + leftRoot + "; rightRoot: " + rightRoot);
            System.out.println("yInit: " + yInit + "; yMax: " + yMax + "; max: " + maxExists);
            double constValue = func.integrate(yInit, 1.0, 5, 1);
            double disValue = Math.rint(13.397260273972602 * constValue * 10.0);
            return disValue / 10.0;
        }
        System.out.println("Unphysical values");
        return Double.NaN;
    }

    public static int getUniverseType(double radiation, double matter, double constant, double domainWall, double cosString, double darkMatter) {
        double uType = radiation + matter + constant + domainWall + cosString + darkMatter;
        if (uType == 1.0) {
            return 0;
        }
        if (uType > 1.0) {
            return 2;
        }
        return 1;
    }
}

