/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.model;

import edu.calstatela.scivi.model.CustomMath;
import edu.calstatela.scivi.model.helper.FuncIntegrate;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RedShiftMagnitude {
    protected RedShiftMagnitude() {
    }

    public static JFreeChart generateChart(double redshift, double radiation, double matter, double constant, double texture, double cosString, double darkMatter) {
        XYSeries series = RedShiftMagnitude.generateDataSeries(redshift, radiation, matter, constant, texture, cosString, darkMatter);
        XYSeriesCollection xyDataset = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart("", "", "", xyDataset, PlotOrientation.VERTICAL, false, false, false);
        return chart;
    }

    public static XYSeries generateDataSeries(double redshift, double radiation, double matter, double constant, double texture, double cosString, double darkMatter) {
        double c_radius;
        double temp2;
        double dm_empty;
        double temp;
        double chi;
        double pre_chi;
        double z;
        double omega_sum = radiation + matter + constant + texture + cosString + darkMatter;
        double lum_dh = 0.0;
        double[][] results = new double[1005][2];
        double z_increment = redshift / 1000.0;
        int counter = 0;
        FuncIntegrate func = new FuncIntegrate();
        func.setParameters(radiation, matter, darkMatter, cosString, omega_sum, texture, constant);
        double prev_pre_chi = 0.0;
        double prev_z = 0.0;
        if (omega_sum == 1.0) {
            for (z = 0.001; z <= redshift; z += z_increment) {
                pre_chi = prev_pre_chi + func.integrate(prev_z, z, 2, 2);
                prev_z = z;
                prev_pre_chi = pre_chi;
                chi = pre_chi;
                temp = 1.0 + z;
                lum_dh = temp * chi;
                dm_empty = 5.0 * CustomMath.log10(lum_dh / (0.5 * (temp * temp - 1.0)));
                results[counter][0] = z;
                results[counter][1] = dm_empty;
                ++counter;
            }
        } else if (omega_sum > 1.0) {
            temp2 = Math.sqrt(omega_sum - 1.0);
            for (z = 0.001; z <= redshift; z += z_increment) {
                pre_chi = prev_pre_chi + func.integrate(prev_z, z, 2, 2);
                prev_z = z;
                prev_pre_chi = pre_chi;
                chi = pre_chi * temp2;
                c_radius = Math.sin(chi);
                temp = 1.0 + z;
                lum_dh = temp * c_radius / temp2;
                dm_empty = 5.0 * CustomMath.log10(lum_dh / (0.5 * (temp * temp - 1.0)));
                results[counter][0] = z;
                results[counter][1] = dm_empty;
                ++counter;
            }
        } else if (omega_sum < 1.0) {
            temp2 = Math.sqrt(1.0 - omega_sum);
            for (z = 0.001; z <= redshift; z += z_increment) {
                pre_chi = prev_pre_chi + func.integrate(prev_z, z, 2, 2);
                prev_z = z;
                prev_pre_chi = pre_chi;
                chi = pre_chi * temp2;
                c_radius = CustomMath.sinh(chi);
                temp = 1.0 + z;
                lum_dh = temp * c_radius / temp2;
                dm_empty = 5.0 * CustomMath.log10(lum_dh / (0.5 * (temp * temp - 1.0)));
                results[counter][0] = z;
                results[counter][1] = dm_empty;
                ++counter;
            }
        }
        XYSeries series = new XYSeries((Comparable)((Object)"Magnitude and Redshift"));
        for (int i = 0; i < counter; ++i) {
            series.add(results[i][0], results[i][1]);
        }
        return series;
    }

    public static double calculateSupernovaData(double z_upper_bound, double omega_r, double omega_m, double omega_dm, double omega_cs, double omega_dw, double omega_cc, double[][] results) {
        double min;
        double max;
        block19: {
            double prev_z;
            double prev_pre_chi;
            FuncIntegrate func;
            boolean first;
            int counter;
            double z_increment;
            double lum_dh;
            double omega_sum;
            block20: {
                block18: {
                    omega_sum = omega_r + omega_m + omega_dm + omega_cs + omega_dw + omega_cc;
                    lum_dh = 0.0;
                    z_increment = z_upper_bound / 1000.0;
                    counter = 0;
                    max = 0.0;
                    min = 0.0;
                    first = true;
                    func = new FuncIntegrate();
                    func.setParameters(omega_r, omega_m, omega_dm, omega_cs, omega_sum, omega_dw, omega_cc);
                    prev_pre_chi = 0.0;
                    prev_z = 0.0;
                    if (omega_sum != 1.0) break block18;
                    for (double z = 0.001; z <= z_upper_bound; z += z_increment) {
                        double pre_chi = prev_pre_chi + func.integrate(prev_z, z, 2, 2);
                        prev_z = z;
                        prev_pre_chi = pre_chi;
                        double chi = pre_chi;
                        double temp = 1.0 + z;
                        lum_dh = temp * chi;
                        double dm_empty = 5.0 * CustomMath.log10(lum_dh / (0.5 * (temp * temp - 1.0)));
                        double dm_ref = 24.167 + 5.0 * CustomMath.log10(lum_dh);
                        if (first) {
                            max = min = dm_empty;
                            first = false;
                        } else if (dm_empty > max) {
                            max = dm_empty;
                        } else if (dm_empty < min) {
                            min = dm_empty;
                        }
                        results[counter][0] = z;
                        results[counter][1] = dm_ref;
                        ++counter;
                    }
                    break block19;
                }
                if (!(omega_sum > 1.0)) break block20;
                double temp2 = Math.sqrt(omega_sum - 1.0);
                for (double z = 0.001; z <= z_upper_bound; z += z_increment) {
                    double pre_chi = prev_pre_chi + func.integrate(prev_z, z, 2, 2);
                    prev_z = z;
                    prev_pre_chi = pre_chi;
                    double chi = pre_chi * temp2;
                    double c_radius = Math.sin(chi);
                    double temp = 1.0 + z;
                    lum_dh = temp * c_radius / temp2;
                    double dm_empty = 5.0 * CustomMath.log10(lum_dh / (0.5 * (temp * temp - 1.0)));
                    double dm_ref = 24.167 + 5.0 * CustomMath.log10(lum_dh);
                    if (first) {
                        max = min = dm_empty;
                        first = false;
                    } else if (dm_empty > max) {
                        max = dm_empty;
                    } else if (dm_empty < min) {
                        min = dm_empty;
                    }
                    results[counter][0] = z;
                    results[counter][1] = dm_ref;
                    ++counter;
                }
                break block19;
            }
            if (!(omega_sum < 1.0)) break block19;
            double temp2 = Math.sqrt(1.0 - omega_sum);
            for (double z = 0.001; z <= z_upper_bound; z += z_increment) {
                double pre_chi = prev_pre_chi + func.integrate(prev_z, z, 2, 2);
                prev_z = z;
                prev_pre_chi = pre_chi;
                double chi = pre_chi * temp2;
                double c_radius = CustomMath.sinh(chi);
                double temp = 1.0 + z;
                lum_dh = temp * c_radius / temp2;
                double dm_empty = 5.0 * CustomMath.log10(lum_dh / (0.5 * (temp * temp - 1.0)));
                double dm_ref = 24.167 + 5.0 * CustomMath.log10(lum_dh);
                if (first) {
                    max = min = dm_empty;
                    first = false;
                } else if (dm_empty > max) {
                    max = dm_empty;
                } else if (dm_empty < min) {
                    min = dm_empty;
                }
                results[counter][0] = z;
                results[counter][1] = dm_ref;
                ++counter;
            }
        }
        return max - min;
    }
}

