/*
 * Decompiled with CFR 0.152.
 */
package edu.calstatela.scivi.control;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import edu.calstatela.scivi.model.OmegaValues;
import edu.calstatela.scivi.model.RedShiftMagnitude;
import edu.calstatela.scivi.model.Supernova;
import edu.calstatela.scivi.model.TimeDistance;
import edu.calstatela.scivi.model.helper.SupernovaGeneration;
import edu.calstatela.scivi.model.helper.SupernovaReader;
import edu.calstatela.scivi.model.helper.SupernovaReaderException;
import edu.calstatela.scivi.ui.ChartsJPanel;
import edu.calstatela.scivi.ui.HintJFrame;
import edu.calstatela.scivi.ui.MainJFrame;
import edu.calstatela.scivi.ui.PanJScrollPane;
import edu.calstatela.scivi.ui.RadarEffectJLayeredPane;
import edu.calstatela.scivi.ui.ScrollPaneFinderChartLink;
import edu.calstatela.scivi.ui.SupernovaImageJPanel;
import edu.calstatela.scivi.ui.SupernovaJPanel;
import edu.calstatela.scivi.ui.ZoomEffectJPanel;
import edu.calstatela.scivi.util.ResourceManager;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MainController {
    private MainJFrame mainView = null;
    private HintJFrame hintView = null;
    private RadarEffectJLayeredPane radarPane = null;
    private ZoomEffectJPanel zoomJPanel = null;
    private PanJScrollPane jScrollPaneUniverse = null;
    private ScrollPaneFinderChartLink scrollFinderLink;
    private double xScale;
    private double yScale;
    private List<Supernova> supernovae = null;
    private static int graphCount = 1;
    private XYSeries supernovaSeries = null;
    private JFreeChart base = null;
    private Font titleFont = new Font("Tahoma", 1, 11);
    private Font sideTextFont = new Font("Tahoma", 0, 9);
    private Font omegaTextFont = new Font("Tahoma", 0, 9);
    private int userLevel;
    private boolean newValues = true;

    public MainController() {
        long start5 = 0L;
        long end5 = 0L;
        long start6 = 0L;
        long end6 = 0L;
        long start7 = 0L;
        long end7 = 0L;
        long start8 = 0L;
        long end8 = 0L;
        long start9 = 0L;
        long end9 = 0L;
        long start1 = System.nanoTime();
        try {
            Skin theSkinToUse = SkinLookAndFeel.loadThemePack(ResourceManager.getURL("global.path.theme"));
            SkinLookAndFeel.setSkin(theSkinToUse);
            UIManager.setLookAndFeel(new SkinLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long end1 = System.nanoTime();
        long start2 = System.nanoTime();
        long end2 = System.nanoTime();
        long start3 = System.nanoTime();
        try {
            start5 = System.nanoTime();
            BufferedImage univImg = null;
            BufferedImage invUnivImg = null;
            BufferedImage initialImg = null;
            BufferedImage novaImg = null;
            univImg = ResourceManager.getImage("global.path.image.universe");
            invUnivImg = ResourceManager.getImage("global.path.image.inverseuniverse");
            initialImg = ResourceManager.getImage("global.path.image.initial");
            novaImg = ResourceManager.getImage("global.path.image.explode");
            end5 = System.nanoTime();
            start8 = System.nanoTime();
            double aspectRatio = (double)invUnivImg.getWidth() / (double)invUnivImg.getHeight();
            this.hintView = new HintJFrame(initialImg, invUnivImg, aspectRatio);
            this.mainView = MainJFrame.getInstance(this.hintView, this.hintView.getJLayeredPane1());
            Dimension imagePaneDimension = this.mainView.getImagePanelDimension();
            int w = (int)imagePaneDimension.getWidth();
            int h = (int)imagePaneDimension.getHeight();
            end8 = System.nanoTime();
            start6 = System.nanoTime();
            this.jScrollPaneUniverse = new PanJScrollPane(univImg, imagePaneDimension);
            this.radarPane = new RadarEffectJLayeredPane(univImg, this.hintView, w, h);
            this.zoomJPanel = new ZoomEffectJPanel(univImg, w, h);
            end6 = System.nanoTime();
            this.scrollFinderLink = new ScrollPaneFinderChartLink(this.jScrollPaneUniverse.getLeftPane(), this.hintView);
            this.scrollFinderLink.setRectVisible(false);
            this.jScrollPaneUniverse.getLeftPane().getHorizontalScrollBar().addAdjustmentListener(this.scrollFinderLink);
            this.jScrollPaneUniverse.getLeftPane().getVerticalScrollBar().addAdjustmentListener(this.scrollFinderLink);
            start9 = System.nanoTime();
            this.mainView.setImageJPanelContent(this.radarPane);
            this.xScale = (double)invUnivImg.getWidth() / (double)univImg.getWidth();
            this.yScale = (double)invUnivImg.getHeight() / (double)univImg.getHeight();
            end9 = System.nanoTime();
            start7 = System.nanoTime();
            end7 = System.nanoTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long end3 = System.nanoTime();
        long start4 = System.nanoTime();
        this.supernovaSeries = new XYSeries((Comparable)((Object)"Supernovas"));
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        XYSeries s1 = RedShiftMagnitude.generateDataSeries(2.0, 0.3, 0.7, 0.0, 0.0, 0.0, 0.0);
        XYSeries s2 = RedShiftMagnitude.generateDataSeries(2.0, 0.0, 1.0, 0.1, 0.1, 0.0, 0.0);
        XYSeries s3 = RedShiftMagnitude.generateDataSeries(2.0, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0);
        xyDataset.addSeries(s1);
        xyDataset.addSeries(s2);
        xyDataset.addSeries(s3);
        this.base = ChartFactory.createXYLineChart("Universe Types", ResourceManager.getString("ui.chart.model.domain"), ResourceManager.getString("ui.chart.model.range"), xyDataset, PlotOrientation.VERTICAL, false, false, false);
        this.base.getTitle().setFont(this.titleFont);
        XYPlot plot = this.base.getXYPlot();
        plot.getDomainAxis().setLabelFont(this.sideTextFont);
        plot.getDomainAxis().setTickLabelFont(this.sideTextFont);
        plot.getRangeAxis().setLabelFont(this.sideTextFont);
        plot.getRangeAxis().setTickLabelFont(this.sideTextFont);
        long end4 = System.nanoTime();
        System.out.println("end1-start1: " + (double)(end1 - start1) / 1.0E9 + " s");
        System.out.println("end2-start2: " + (double)(end2 - start2) / 1.0E9 + " s");
        System.out.println("end3-start3: " + (double)(end3 - start3) / 1.0E9 + " s");
        System.out.println("end4-start4: " + (double)(end4 - start4) / 1.0E9 + " s");
        System.out.println("end5-start5: " + (double)(end5 - start5) / 1.0E9 + " s");
        System.out.println("end6-start6: " + (double)(end6 - start6) / 1.0E9 + " s");
        System.out.println("end7-start7: " + (double)(end7 - start7) / 1.0E9 + " s");
        System.out.println("end8-start8: " + (double)(end8 - start8) / 1.0E9 + " s");
        System.out.println("end9-start9: " + (double)(end9 - start9) / 1.0E9 + " s");
    }

    public static double linearMap(double inputMin, double inputMax, double outputMin, double outputMax, double value) {
        return (value - inputMin) / (inputMax - inputMin) * (outputMax - outputMin) + outputMin;
    }

    public void startApp() {
        this.mainView.setCtrl(this);
        this.mainView.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateModel(double redshift, double radiation, double matter, double constant, double darkMatter, double cosString, double texture) {
        JTabbedPane jTabbedPane;
        OmegaValues omegas = SupernovaGeneration.getOmegaValues();
        XYSeries supernovaDataSeries = RedShiftMagnitude.generateDataSeries(redshift, omegas.omega_r, omegas.omega_m, omegas.omega_cc, omegas.omega_dw, omegas.omega_cs, omegas.omega_dm);
        JFreeChart chart = RedShiftMagnitude.generateChart(redshift, radiation, matter, constant, texture, cosString, darkMatter);
        XYSeriesCollection dataSet = (XYSeriesCollection)chart.getXYPlot().getDataset();
        dataSet.addSeries(this.supernovaSeries);
        if (this.mainView.omegasWithinThreshold()) {
            dataSet.addSeries(supernovaDataSeries);
        }
        chart.setTitle(ResourceManager.getString("ui.chart.magnitude.title"));
        chart.addSubtitle(new TextTitle("radiation: " + radiation + "; matter: " + matter + "; \ndark matter: " + darkMatter + "; cosmic string: " + cosString + "; \ndomain wall: " + texture + "; cosmological constant: " + constant, this.omegaTextFont));
        chart.getXYPlot().getDomainAxis().setLabel(ResourceManager.getString("ui.chart.magnitude.domain"));
        chart.getXYPlot().getRangeAxis().setLabel(ResourceManager.getString("ui.chart.magnitude.range"));
        XYPlot plot = chart.getXYPlot();
        this.supernovaSeries = ((XYSeriesCollection)plot.getDataset()).getSeries(1);
        chart.getTitle().setFont(this.titleFont);
        plot.getDomainAxis().setLabelFont(this.sideTextFont);
        plot.getDomainAxis().setTickLabelFont(this.sideTextFont);
        plot.getRangeAxis().setLabelFont(this.sideTextFont);
        plot.getRangeAxis().setTickLabelFont(this.sideTextFont);
        XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)plot.getRenderer();
        r.setSeriesOutlineStroke(1, new BasicStroke(5.0f));
        r.setSeriesShapesVisible(1, true);
        r.setSeriesShape(1, new Rectangle(-1, -1, 2, 2));
        r.setSeriesLinesVisible(1, false);
        Paint redPaint = r.getSeriesPaint(0);
        Paint bluePaint = r.getSeriesPaint(1);
        Paint greenPaint = r.getSeriesPaint(2);
        r.setSeriesPaint(0, redPaint);
        r.setSeriesPaint(1, bluePaint);
        r.setSeriesPaint(2, greenPaint);
        JFreeChart model = TimeDistance.generateChart(radiation, matter, constant, texture, cosString, darkMatter);
        model.setTitle(ResourceManager.getString("ui.chart.model.title"));
        model.addSubtitle(new TextTitle("radiation: " + radiation + "; matter: " + matter + "; \ndark matter: " + darkMatter + "; cosmic string: " + cosString + "; \ndomain wall: " + texture + "; cosmological constant: " + constant, this.omegaTextFont));
        model.getXYPlot().getDomainAxis().setLabel(ResourceManager.getString("ui.chart.model.domain"));
        model.getXYPlot().getRangeAxis().setLabel(ResourceManager.getString("ui.chart.model.range"));
        model.getTitle().setFont(this.titleFont);
        plot = model.getXYPlot();
        plot.getDomainAxis().setLabelFont(this.sideTextFont);
        plot.getDomainAxis().setTickLabelFont(this.sideTextFont);
        plot.getRangeAxis().setLabelFont(this.sideTextFont);
        plot.getRangeAxis().setTickLabelFont(this.sideTextFont);
        StringBuffer sb = new StringBuffer();
        double omegaSum = radiation + matter + constant + darkMatter + cosString + texture;
        omegaSum = (double)((int)(omegaSum * 1000.0)) / 1000.0;
        if (Math.abs(omegaSum) < 0.001) {
            sb.append(ResourceManager.getString("ui.chart.label.initial") + "\n");
        } else {
            Object[] arg = new Object[]{"" + omegaSum};
            int uType = TimeDistance.getUniverseType(radiation, matter, constant, texture, cosString, darkMatter);
            switch (uType) {
                case 0: {
                    sb.append(MessageFormat.format(ResourceManager.getString("ui.chart.label.flat"), arg));
                    break;
                }
                case 1: {
                    sb.append(MessageFormat.format(ResourceManager.getString("ui.chart.label.open"), arg));
                    break;
                }
                case 2: {
                    sb.append(MessageFormat.format(ResourceManager.getString("ui.chart.label.closed"), arg));
                }
            }
            sb.append(" ");
            double uAge = TimeDistance.getUniverseAge(radiation, matter, constant, texture, cosString, darkMatter);
            arg = new Object[]{uAge + ""};
            sb.append(MessageFormat.format(ResourceManager.getString("ui.chart.label.age"), arg));
        }
        JTabbedPane jTabbedPane2 = jTabbedPane = this.mainView.getChartsJTabbedPane();
        synchronized (jTabbedPane2) {
            if (jTabbedPane.getTabCount() >= 3 || jTabbedPane.getTitleAt(0).equals("")) {
                jTabbedPane.removeTabAt(0);
            }
            Dimension chartJPanelSize = new Dimension(jTabbedPane.getWidth() / 2 - 10, jTabbedPane.getHeight() - 60);
            ChartsJPanel newTab = new ChartsJPanel(chartJPanelSize, chart, model, this.base, sb.toString());
            JTextArea omegaValues = new JTextArea(2, 80);
            omegaValues.setText("radiation: " + radiation + "; matter: " + matter + "; dark matter: " + darkMatter + "; cosmic string: " + cosString + "; domain wall: " + texture + "; cosmological constant: " + constant);
            omegaValues.setEditable(false);
            omegaValues.setLineWrap(true);
            omegaValues.setWrapStyleWord(true);
            double rangeLowerBound = chart.getXYPlot().getRangeAxis().getLowerBound();
            double rangeUpperBound = chart.getXYPlot().getRangeAxis().getUpperBound();
            double domainLowerBound = chart.getXYPlot().getDomainAxis().getLowerBound();
            double domainUpperBound = chart.getXYPlot().getDomainAxis().getUpperBound();
            XYTextAnnotation omegaValues2 = new XYTextAnnotation("r: " + radiation + "; m: " + matter + "; dm: " + darkMatter + "; cs: " + cosString + "; dw: " + texture + "; cc: " + constant, (domainLowerBound + domainUpperBound) / 2.0, (rangeLowerBound + rangeUpperBound) / 2.0);
            omegaValues2.setFont(this.omegaTextFont);
            rangeLowerBound = model.getXYPlot().getRangeAxis().getLowerBound();
            rangeUpperBound = model.getXYPlot().getRangeAxis().getUpperBound();
            domainLowerBound = model.getXYPlot().getDomainAxis().getLowerBound();
            domainUpperBound = model.getXYPlot().getDomainAxis().getUpperBound();
            XYTextAnnotation omegaValues3 = new XYTextAnnotation("r: " + radiation + "; m: " + matter + "; dm: " + darkMatter + "; cs: " + cosString + "; dw: " + texture + "; cc: " + constant, (domainLowerBound + domainUpperBound) / 2.0, (rangeLowerBound + rangeUpperBound) / 2.0);
            omegaValues3.setFont(this.omegaTextFont);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)newTab, "Center");
            jTabbedPane.addTab("GRAPH " + graphCount, panel);
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            ++graphCount;
        }
    }

    public void supernovaClicked(int supernovaID) {
        Supernova s = this.supernovae.get(supernovaID);
        if (!s.isVisible()) {
            JTabbedPane jTabbedPane = this.mainView.getChartsJTabbedPane();
            int count = jTabbedPane.getTabCount();
            ChartsJPanel tab = null;
            for (int i = 0; i < count; ++i) {
                JPanel panel = (JPanel)jTabbedPane.getComponentAt(i);
                if (panel.getComponentCount() < 1 || !(panel.getComponent(0) instanceof ChartsJPanel)) {
                    JOptionPane.showMessageDialog(this.mainView, "Must create graph first!", "Message", 0);
                    return;
                }
                tab = (ChartsJPanel)panel.getComponent(0);
                tab.addSupernovaPlotPoint(s.getMagnitude(), s.getRedShift());
            }
            this.jScrollPaneUniverse.getRightPane().setChartPanel(tab.getCopyMagPanel());
            s.setVisible(true);
            this.hintView.setTargetPanelClicked(s.getX(), s.getY());
            this.supernovaMouseOver(supernovaID, true);
        }
        Iterator<Supernova> it = this.supernovae.iterator();
        int clickedSupernovaCount = 0;
        while (it.hasNext()) {
            Supernova s2 = it.next();
            if (!s2.isVisible()) continue;
            ++clickedSupernovaCount;
        }
        if (clickedSupernovaCount >= 1 && clickedSupernovaCount < 12) {
            this.mainView.setGraphText("\n\n" + ResourceManager.getString("ui.main.graphwindow.text.firstsn"));
            this.mainView.setGraphTextBold(true);
        } else if (clickedSupernovaCount == 12) {
            this.mainView.setGraphText("\n\n" + ResourceManager.getString("ui.main.graphwindow.text.allsn"));
            this.mainView.setGraphTextBold(true);
        }
        switch (clickedSupernovaCount) {
            case 1: {
                this.hintView.setVisible(true);
                this.hintView.toFront();
                this.ShowPopupTip(ResourceManager.getString("popups.foundfirst.text"), ResourceManager.getString("popups.foundfirst.title"));
                break;
            }
            case 6: {
                this.hintView.setVisible(true);
                this.hintView.toFront();
                this.ShowPopupTip(ResourceManager.getString("popups.foundhalf.text"), ResourceManager.getString("popups.foundhalf.title"));
                break;
            }
            default: {
                if (clickedSupernovaCount != this.supernovae.size()) break;
                this.hintView.setVisible(true);
                this.hintView.toFront();
                this.ShowPopupTip(ResourceManager.getString("popups.foundall.text"), ResourceManager.getString("popups.foundall.title"));
            }
        }
    }

    public void supernovaMouseOver(int supernovaID, boolean over) {
        Supernova s = this.supernovae.get(supernovaID);
        if (s.isVisible()) {
            Rectangle viewRect = this.jScrollPaneUniverse.getRightPane().getViewport().getViewRect();
            boolean side = (double)s.getX() < viewRect.getCenterX();
            this.jScrollPaneUniverse.getRightPane().updateChartPanel(over, side);
        }
    }

    public void startGame(int level) {
        if (this.newValues) {
            try {
                this.supernovae = new SupernovaReader().convertSupernovaData(level, ResourceManager.getString("global.path.data.supernovae"));
            }
            catch (SupernovaReaderException ex) {
                ex.printStackTrace();
            }
            this.hintView.recomputePanelsLocation();
            this.jScrollPaneUniverse.recomputePanelsLocation();
            BufferedImage novaImg = null;
            try {
                novaImg = ResourceManager.getImage("global.path.image.explode");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Iterator<Supernova> it = this.supernovae.iterator();
            boolean i = false;
            double minRadius = SupernovaReader.findSupernovaMinRadius(this.supernovae);
            double maxRadius = SupernovaReader.findSupernovaMaxRadius(this.supernovae);
            while (it.hasNext()) {
                Supernova nova = it.next();
                int supernovaPanelSize = (int)Math.rint(nova.getRadius() * 1.0) + 14;
                SupernovaJPanel novaJPanel = new SupernovaJPanel(nova, supernovaPanelSize, this);
                SupernovaImageJPanel novaImageJPanel = new SupernovaImageJPanel(nova, supernovaPanelSize, novaImg, this);
                this.jScrollPaneUniverse.addSupernovaJPanel(novaJPanel, novaImageJPanel);
                int scaledX = (int)(this.xScale * (double)nova.getX());
                int scaledY = (int)(this.yScale * (double)nova.getY());
                this.hintView.addNovaHint(scaledX, scaledY, this.xScale, this.yScale, nova);
            }
        }
        this.userLevel = level;
        if (this.hintView == null || !this.hintView.isVisible()) {
            int response = JOptionPane.showConfirmDialog(this.mainView, "Would you like to skip the supernova discovery process and directly begin experimenting with graphs?\n(Click \"No\" if this is your first time running MyUniverse.)", "Skip to Graphs?", 0, 3);
            if (response == 0) {
                this.showHint();
            } else {
                new Thread(new animationActionHandler()).start();
            }
        } else {
            new Thread(new animationActionHandler()).start();
        }
    }

    public void endGame() {
        int value = JOptionPane.showConfirmDialog(this.mainView, "Use new setting? (yes / no)", "Setting", 0, 3);
        this.newValues = value == 0;
        this.supernovaSeries = new XYSeries((Comparable)((Object)"Supernovas"));
        for (Supernova s : this.supernovae) {
            s.setVisible(false);
        }
        this.mainView.setImageJPanelContent(this.radarPane);
        this.mainView.showButtons(1);
        JTabbedPane jTabbedPane = this.mainView.getChartsJTabbedPane();
        jTabbedPane.addTab("", new JPanel());
        while (jTabbedPane.getTabCount() > 1) {
            System.out.println("TAB LEFT " + jTabbedPane.getTabCount());
            jTabbedPane.removeTabAt(0);
        }
        this.mainView.setHintPaneText("");
        this.mainView.setMessageTextBold(false);
        this.mainView.setMessageText(ResourceManager.getString("ui.main.mainwindow.text.initial"));
        this.mainView.setGraphText("");
        this.mainView.repaint();
        this.hintView.hideTargetPanels();
        this.hintView.resetTargetPanelsClick();
        this.hintView.switchImageToInitial();
        this.scrollFinderLink.setRectVisible(false);
        this.radarPane.setLineVisible(false);
        if (this.hintView != null) {
            this.hintView.setVisible(false);
        }
        graphCount = 1;
    }

    public void closeApp() {
        this.mainView.closeApp();
    }

    public void showHint() {
        if (this.hintView != null && !this.hintView.isVisible()) {
            this.hintView.setVisible(true);
        }
    }

    public void moveHintToBack() {
        this.mainView.toFront();
    }

    private void ShowPopupTip(String text, String title) {
        if (this.userLevel == 1) {
            JOptionPane.showMessageDialog(this.hintView, text, title, 1);
        }
    }

    class animationActionHandler
    implements Runnable {
        animationActionHandler() {
        }

        public void run() {
            MainController.this.mainView.setStartEnabled(false);
            MainController.this.hintView.switchImage();
            MainController.this.mainView.setHintPaneText(ResourceManager.getString("ui.main.mainwindow.text.finderpane"));
            MainController.this.mainView.setMessageText(ResourceManager.getString("ui.main.mainwindow.text.sweep"));
            MainController.this.radarPane.setLineVisible(true);
            MainController.this.radarPane.addNovaeList(MainController.this.supernovae);
            MainController.this.radarPane.startAnimation();
            while (!MainController.this.radarPane.isDone()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            MainController.this.scrollFinderLink.setRectVisible(true);
            MainController.this.jScrollPaneUniverse.reset();
            MainController.this.mainView.setImageJPanelContent(MainController.this.jScrollPaneUniverse);
            MainController.this.mainView.showButtons(0);
            MainController.this.mainView.postShowGraphEvent();
            MainController.this.mainView.postUpdateGraphEvent();
            MainController.this.mainView.setMessageText(ResourceManager.getString("ui.main.mainwindow.text.split"));
            MainController.this.mainView.setMessageTextBold(true);
            JOptionPane.showMessageDialog(MainController.this.mainView, ResourceManager.getString("popups.scancomplete.text"), ResourceManager.getString("popups.scancomplete.title"), 1);
        }
    }
}

